/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.yaml2json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.payneteasy.yaml2json.Yaml2GsonConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.lowlevel.Compose;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;

public class YamlParser {
    private final Yaml2GsonConverter yaml2GsonConverter = new Yaml2GsonConverter();
    private final Compose compose;
    private final Gson gson;

    public YamlParser() {
        this(LoadSettings.builder().build(), new Gson());
    }

    public YamlParser(LoadSettings aLoaderSettings, Gson aGson) {
        this.compose = new Compose(aLoaderSettings);
        this.gson = aGson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T parseFile(File aFile, Class<T> aClass) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(aFile), StandardCharsets.UTF_8);){
            Node node = (Node)this.compose.composeReader((Reader)reader).orElseThrow(() -> new IllegalStateException("No any node"));
            JsonObject object = this.yaml2GsonConverter.convertToJson((MappingNode)node);
            Object object2 = this.gson.fromJson((JsonElement)object, aClass);
            return (T)object2;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot parse file " + aFile.getAbsolutePath(), e);
        }
    }

    public <T> T parseText(String aText, Class<T> aClass) {
        Node node = (Node)this.compose.composeString(aText).orElseThrow(() -> new IllegalStateException("No any node"));
        JsonObject object = this.yaml2GsonConverter.convertToJson((MappingNode)node);
        return (T)this.gson.fromJson((JsonElement)object, aClass);
    }
}

