/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.yaml2json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.payneteasy.yaml2json.IWarningListener;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

public class Yaml2GsonConverter {
    private final IWarningListener listener;

    public Yaml2GsonConverter() {
        this(aNode -> {});
    }

    public Yaml2GsonConverter(IWarningListener listener) {
        this.listener = listener;
    }

    public JsonObject convertToJson(MappingNode aNode) {
        return this.convertToJson(new JsonObject(), aNode);
    }

    private JsonObject convertToJson(JsonObject aObject, MappingNode aNode) {
        for (NodeTuple tuple : aNode.getValue()) {
            Node keyNode = tuple.getKeyNode();
            if (keyNode.getNodeType() != NodeType.SCALAR) {
                this.listener.nodeIsNotScalar(keyNode);
                continue;
            }
            String name = ((ScalarNode)keyNode).getValue();
            Node valueNode = tuple.getValueNode();
            aObject.add(name, this.convertAny(valueNode));
        }
        return aObject;
    }

    private JsonArray convertSequence(Node aNode) {
        SequenceNode sequenceNode = (SequenceNode)aNode;
        JsonArray array = new JsonArray();
        for (Node node : sequenceNode.getValue()) {
            array.add(this.convertAny(node));
        }
        return array;
    }

    private JsonObject convertMapping(Node aNode) {
        MappingNode mappingNode = (MappingNode)aNode;
        return this.convertToJson(new JsonObject(), mappingNode);
    }

    private JsonPrimitive convertScalar(Node aNode) {
        ScalarNode scalarNode = (ScalarNode)aNode;
        return new JsonPrimitive(scalarNode.getValue());
    }

    private JsonElement convertAny(Node aValueNode) {
        switch (aValueNode.getNodeType()) {
            case SCALAR: {
                return this.convertScalar(aValueNode);
            }
            case MAPPING: {
                return this.convertMapping(aValueNode);
            }
            case SEQUENCE: {
                return this.convertSequence(aValueNode);
            }
            case ANCHOR: {
                throw new IllegalStateException("Anchor node type " + aValueNode);
            }
        }
        throw new IllegalStateException("Unknown node type " + aValueNode.getNodeType());
    }
}

