/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.telegram.bot.client.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.payneteasy.telegram.bot.client.TelegramCommandException;
import com.payneteasy.telegram.bot.client.http.HttpClientTimeouts;
import com.payneteasy.telegram.bot.client.http.ITelegramHttpClient;
import com.payneteasy.telegram.bot.client.http.SimpleHttpClient;
import com.payneteasy.telegram.bot.client.http.SimpleHttpResponse;
import com.payneteasy.telegram.bot.client.messages.TelegramStandardResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramHttpClientImpl
implements ITelegramHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramHttpClientImpl.class);
    private final String baseUrl;
    private final String token;
    private final HttpClientTimeouts timeouts;
    private final Gson gson;
    private final AtomicLong commandId = new AtomicLong();

    public TelegramHttpClientImpl(String baseUrl, String token, HttpClientTimeouts timeouts, Gson gson) {
        this.baseUrl = baseUrl;
        this.token = token;
        this.timeouts = timeouts;
        this.gson = gson;
    }

    public TelegramHttpClientImpl(String token) {
        this("https://api.telegram.org/bot", token, new HttpClientTimeouts(30000, 30000, 30000), new GsonBuilder().setPrettyPrinting().create());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(String aMethodName, Class<T> aResponseClass) {
        String id = this.nextCommandId();
        try (SimpleHttpClient client = new SimpleHttpClient();){
            client.connect(this.baseUrl + this.token + "/" + aMethodName, this.timeouts.getConnectionMs(), this.timeouts.getReadMs(), "GET");
            client.sendHeader("Content-Type", "application/json");
            LOG.debug("{} {}: request", (Object)id, (Object)aMethodName);
            SimpleHttpResponse response = client.fetchResponse();
            String json = new String(response.getBody(), StandardCharsets.UTF_8);
            LOG.debug("{} {}: response {}", new Object[]{id, aMethodName, json});
            if (response.getStatusCode() != 200) {
                throw new IllegalStateException(json);
            }
            Object object = this.gson.fromJson(json, aResponseClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new TelegramCommandException("Cannot invoke " + aMethodName, (Throwable)e, id, -1);
        }
    }

    private String nextCommandId() {
        return String.valueOf(this.commandId.incrementAndGet());
    }

    @Override
    public <R, T> T post(String aMethodName, R aRequest, Class<T> aResponseClass) {
        String id = this.nextCommandId();
        return this.post(id, aMethodName, aRequest, aResponseClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, T> T post(String id, String aMethodName, R aRequest, Class<T> aResponseClass) {
        try (SimpleHttpClient client = new SimpleHttpClient();){
            client.connect(this.baseUrl + this.token + "/" + aMethodName, this.timeouts.getConnectionMs(), this.timeouts.getReadMs(), "POST");
            client.sendHeader("Content-Type", "application/json");
            String requestJson = this.gson.toJson(aRequest);
            LOG.debug("{} {}: request  {}", new Object[]{id, aMethodName, requestJson});
            client.sendBody(requestJson.getBytes(StandardCharsets.UTF_8));
            SimpleHttpResponse response = client.fetchResponse();
            String responseJson = new String(response.getBody(), StandardCharsets.UTF_8);
            LOG.debug("{} {}: response {}", new Object[]{id, aMethodName, responseJson});
            if (response.getStatusCode() != 200) {
                throw new TelegramCommandException(responseJson, id, -2);
            }
            Object object = this.gson.fromJson(responseJson, aResponseClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new TelegramCommandException("Cannot invoke " + aMethodName, (Throwable)e, id, -1);
        }
    }

    @Override
    public <R> void post(String aMethodName, R aRequest) {
        String id = this.nextCommandId();
        TelegramStandardResponse response = this.post(id, aMethodName, aRequest, TelegramStandardResponse.class);
        if (!response.isOk()) {
            throw new TelegramCommandException(response.getDescription(), id, response.getErrorCode());
        }
    }
}

