/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.telegram.bot.client.messages;

import com.google.gson.annotations.SerializedName;
import com.payneteasy.telegram.bot.client.model.ParseMode;
import com.payneteasy.telegram.bot.client.model.replykeyboard.ReplyKeyboard;

public class TelegramMessageRequest {
    @SerializedName(value="chat_id")
    private final int chatId;
    private final String text;
    @SerializedName(value="parse_mode")
    private final ParseMode parseMode;
    @SerializedName(value="reply_markup")
    private final ReplyKeyboard replyMarkup;

    TelegramMessageRequest(int chatId, String text, ParseMode parseMode, ReplyKeyboard replyMarkup) {
        this.chatId = chatId;
        this.text = text;
        this.parseMode = parseMode;
        this.replyMarkup = replyMarkup;
    }

    public static TelegramMessageRequestBuilder builder() {
        return new TelegramMessageRequestBuilder();
    }

    public int getChatId() {
        return this.chatId;
    }

    public String getText() {
        return this.text;
    }

    public ParseMode getParseMode() {
        return this.parseMode;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelegramMessageRequest)) {
            return false;
        }
        TelegramMessageRequest other = (TelegramMessageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChatId() != other.getChatId()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        ParseMode this$parseMode = this.getParseMode();
        ParseMode other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !((Object)((Object)this$parseMode)).equals((Object)other$parseMode)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TelegramMessageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChatId();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        ParseMode $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : ((Object)((Object)$parseMode)).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        return result;
    }

    public String toString() {
        return "TelegramMessageRequest(chatId=" + this.getChatId() + ", text=" + this.getText() + ", parseMode=" + (Object)((Object)this.getParseMode()) + ", replyMarkup=" + this.getReplyMarkup() + ")";
    }

    public static class TelegramMessageRequestBuilder {
        private int chatId;
        private String text;
        private ParseMode parseMode;
        private ReplyKeyboard replyMarkup;

        TelegramMessageRequestBuilder() {
        }

        public TelegramMessageRequestBuilder chatId(int chatId) {
            this.chatId = chatId;
            return this;
        }

        public TelegramMessageRequestBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TelegramMessageRequestBuilder parseMode(ParseMode parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public TelegramMessageRequestBuilder replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public TelegramMessageRequest build() {
            return new TelegramMessageRequest(this.chatId, this.text, this.parseMode, this.replyMarkup);
        }

        public String toString() {
            return "TelegramMessageRequest.TelegramMessageRequestBuilder(chatId=" + this.chatId + ", text=" + this.text + ", parseMode=" + (Object)((Object)this.parseMode) + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

