/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.telegram.bot.client.messages;

import com.google.gson.annotations.SerializedName;
import lombok.NonNull;

public class ChatActionRequest {
    @SerializedName(value="chat_id")
    private final Integer chatId;
    @NonNull
    private final Action action;

    ChatActionRequest(Integer chatId, @NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.chatId = chatId;
        this.action = action;
    }

    public static ChatActionRequestBuilder builder() {
        return new ChatActionRequestBuilder();
    }

    public Integer getChatId() {
        return this.chatId;
    }

    @NonNull
    public Action getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatActionRequest)) {
            return false;
        }
        ChatActionRequest other = (ChatActionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$chatId = this.getChatId();
        Integer other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !((Object)this$chatId).equals(other$chatId)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatActionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : ((Object)$chatId).hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        return result;
    }

    public String toString() {
        return "ChatActionRequest(chatId=" + this.getChatId() + ", action=" + (Object)((Object)this.getAction()) + ")";
    }

    public static class ChatActionRequestBuilder {
        private Integer chatId;
        private Action action;

        ChatActionRequestBuilder() {
        }

        public ChatActionRequestBuilder chatId(Integer chatId) {
            this.chatId = chatId;
            return this;
        }

        public ChatActionRequestBuilder action(@NonNull Action action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            return this;
        }

        public ChatActionRequest build() {
            return new ChatActionRequest(this.chatId, this.action);
        }

        public String toString() {
            return "ChatActionRequest.ChatActionRequestBuilder(chatId=" + this.chatId + ", action=" + (Object)((Object)this.action) + ")";
        }
    }

    public static enum Action {
        typing,
        upload_photo,
        record_video,
        upload_video,
        record_voice,
        upload_voice,
        upload_document,
        find_location,
        record_video_note,
        upload_video_note;

    }
}

