/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.telegram.bot.client.impl;

import com.payneteasy.telegram.bot.client.ITelegramService;
import com.payneteasy.telegram.bot.client.http.ITelegramHttpClient;
import com.payneteasy.telegram.bot.client.messages.ChatActionRequest;
import com.payneteasy.telegram.bot.client.messages.EditMessageTextRequest;
import com.payneteasy.telegram.bot.client.messages.TelegramGetUpdatesRequest;
import com.payneteasy.telegram.bot.client.messages.TelegramGetUpdatesResponse;
import com.payneteasy.telegram.bot.client.messages.TelegramMessageRequest;
import com.payneteasy.telegram.bot.client.messages.TelegramSetMyCommandsRequest;
import com.payneteasy.telegram.bot.client.messages.TelegramWebhookRequest;
import com.payneteasy.telegram.bot.client.model.TelegramMessage;
import com.payneteasy.telegram.bot.client.model.TelegramUser;

public class TelegramServiceImpl
implements ITelegramService {
    private final ITelegramHttpClient http;

    public TelegramServiceImpl(ITelegramHttpClient aHttp) {
        this.http = aHttp;
    }

    @Override
    public TelegramUser getMe() {
        return this.http.get("getMe", TelegramUser.class);
    }

    @Override
    public TelegramMessage sendMessage(TelegramMessageRequest aRequest) {
        return this.http.post("sendMessage", aRequest, TelegramMessage.class);
    }

    @Override
    public void setWebhook(TelegramWebhookRequest aRequest) {
        this.http.post("setWebhook", aRequest);
    }

    @Override
    public void clearWebhook() {
        this.http.post("setWebhook", new TelegramWebhookRequest(""));
    }

    @Override
    public void setMyCommands(TelegramSetMyCommandsRequest aMyCommands) {
        this.http.post("setMyCommands", aMyCommands);
    }

    @Override
    public void sendChatAction(ChatActionRequest aChatActionRequest) {
        this.http.post("sendChatAction", aChatActionRequest);
    }

    @Override
    public TelegramGetUpdatesResponse getUpdates(TelegramGetUpdatesRequest aRequest) {
        return this.http.post("getUpdates", aRequest, TelegramGetUpdatesResponse.class);
    }

    @Override
    public TelegramMessage editMessageText(EditMessageTextRequest aRequest) {
        return this.http.post("editMessageText", aRequest, TelegramMessage.class);
    }
}

