/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.impl.TailQueueDirSender;
import com.payneteasy.tailqueue.impl.TailQueueFileTailer;
import java.io.File;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueSenderTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueSenderTask.class);
    private final File dir;
    private final TailQueueDirSender dirSender;
    private final TailQueueFileTailer fileTailer;
    private final Duration sleepDuration;
    private final ITailQueueMetricsListener metricsListener;

    public TailQueueSenderTask(File dir, TailQueueDirSender dirSender, TailQueueFileTailer fileTailer, Duration sleepDuration, ITailQueueMetricsListener metricsListener) {
        this.dir = dir;
        this.dirSender = dirSender;
        this.fileTailer = fileTailer;
        this.sleepDuration = sleepDuration;
        this.metricsListener = metricsListener;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("sender-" + this.dir.getParent() + "-" + this.dir.getName());
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.dirSender.processDir();
                this.fileTailer.tailOneFile();
                LOG.trace("Sleeping {} between sending dir ...", (Object)this.sleepDuration);
                Thread.sleep(this.sleepDuration.toMillis());
            }
            catch (InterruptedException e) {
                LOG.warn("Sender cycle interrupted");
                break;
            }
            catch (Exception e) {
                LOG.error("Cannot process dir {}", (Object)this.dir, (Object)e);
                this.metricsListener.didSenderTaskErrorProcessingDir();
            }
        }
        LOG.debug("Exited from sender task");
    }
}

