/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueSender;
import com.payneteasy.tailqueue.impl.TailQueueFileFilter;
import com.payneteasy.tailqueue.impl.TailQueueStrictLineReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueFileTailer {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueFileTailer.class);
    private final File dir;
    private final ITailQueueSender sender;
    private final TailQueueFileFilter fileFilter;
    private final Duration lineDuration;
    private final ITailQueueMetricsListener metricsListener;

    public TailQueueFileTailer(File dir, ITailQueueSender sender, TailQueueFileFilter fileFilter, Duration lineDuration, ITailQueueMetricsListener metricsListener) {
        this.dir = dir;
        this.sender = sender;
        this.fileFilter = fileFilter;
        this.lineDuration = lineDuration;
        this.metricsListener = metricsListener;
    }

    public void tailOneFile() throws InterruptedException {
        Optional<File> fileOpt = this.findOneFile();
        if (!fileOpt.isPresent()) {
            return;
        }
        this.tailFile(fileOpt.get());
    }

    private void tailFile(File aFile) throws InterruptedException {
        LOG.debug("Start tailing file {} ...", (Object)aFile.getAbsolutePath());
        try (TailQueueStrictLineReader in = new TailQueueStrictLineReader(new InputStreamReader(Files.newInputStream(aFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            while (!Thread.currentThread().isInterrupted()) {
                String line = in.readLine();
                if (line != null) {
                    LOG.debug("Send line {}:{} ...", (Object)aFile.getName(), (Object)in.getLineNumber());
                    this.sender.sendMessage(line);
                    this.metricsListener.didSenderFileSendLine(in.getLineNumber());
                    this.metricsListener.didSenderFileSendLineSuccess();
                    continue;
                }
                if (this.hasAnotherFile()) {
                    LOG.debug("Found another file. Exiting ...");
                    return;
                }
                this.sleepForNewLine();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Tailing file interrupted {}", (Object)aFile.getAbsolutePath());
            throw e;
        }
        catch (Exception e) {
            LOG.error("Cannot process file {}", (Object)aFile.getAbsolutePath(), (Object)e);
            this.metricsListener.didSenderFileError();
        }
    }

    private void sleepForNewLine() throws InterruptedException {
        Thread.sleep(this.lineDuration.toMillis());
    }

    private Optional<File> findOneFile() {
        File[] files = this.dir.listFiles(this.fileFilter);
        return files != null && files.length == 1 ? Optional.of(files[0]) : Optional.empty();
    }

    private boolean hasAnotherFile() {
        File[] files = this.dir.listFiles(this.fileFilter);
        return files != null && files.length >= 2;
    }
}

