/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueFileSender;
import com.payneteasy.tailqueue.TailQueueFileSenderContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueFileSenderImpl
implements ITailQueueFileSender {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueFileSenderImpl.class);

    @Override
    public void sendFile(TailQueueFileSenderContext aContext) throws IOException {
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(aContext.getFile().toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                LOG.debug("Sending line {}:{} ({}/{})...", new Object[]{aContext.getFile().getName(), in.getLineNumber(), aContext.getCurrent(), aContext.getCount()});
                aContext.getSender().sendMessage(line);
                aContext.getMetricsListener().didSenderDirSendLineSuccess();
            }
        }
    }
}

