/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueFileSender;
import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueRetention;
import com.payneteasy.tailqueue.ITailQueueSender;
import com.payneteasy.tailqueue.TailQueueFileSenderContext;
import com.payneteasy.tailqueue.impl.TailQueueFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueDirSender {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueDirSender.class);
    private final File dir;
    private final TailQueueFileFilter fileFilter;
    private final ITailQueueSender sender;
    private final ITailQueueRetention retention;
    private final ITailQueueMetricsListener metricsListener;
    private final ITailQueueFileSender fileSender;

    public TailQueueDirSender(File dir, TailQueueFileFilter fileFilter, ITailQueueSender sender, ITailQueueRetention retention, ITailQueueMetricsListener metricsListener, ITailQueueFileSender fileSender) {
        this.dir = dir;
        this.fileFilter = fileFilter;
        this.sender = sender;
        this.retention = retention;
        this.metricsListener = metricsListener;
        this.fileSender = fileSender;
    }

    void processDir() {
        List<File> filesToProcess = this.createFileListForDirProcess();
        int count = filesToProcess.size();
        if (filesToProcess.isEmpty()) {
            LOG.trace("Files to process {}", (Object)count);
        } else {
            LOG.debug("Files to process {}", (Object)count);
        }
        for (int i = 0; i < count; ++i) {
            File file = filesToProcess.get(i);
            try {
                LOG.debug("Sending file {} ...", (Object)file.getAbsolutePath());
                this.sendFile(file, i, count);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot process file " + file.getAbsolutePath(), e);
            }
            try {
                this.archiveFile(file, i, count);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot archive file " + file.getAbsolutePath(), e);
            }
        }
    }

    private void sendFile(File file, int aCurrent, int aCount) throws IOException {
        TailQueueFileSenderContext context = TailQueueFileSenderContext.builder().file(file).current(aCurrent).count(aCount).sender(this.sender).metricsListener(this.metricsListener).build();
        this.fileSender.sendFile(context);
        this.metricsListener.didSenderDirSendFile(aCurrent, aCount);
    }

    private void archiveFile(File aFile, int current, int count) {
        LOG.debug("Archiving file ({}/{}) {}...", new Object[]{aFile, current, count});
        this.retention.archiveFile(aFile);
        this.metricsListener.didSenderDirArchiveFile();
    }

    private List<File> createFileListForDirProcess() {
        File[] files = this.dir.listFiles(this.fileFilter);
        if (files == null || files.length == 0) {
            this.metricsListener.didSenderDirFilesCount(0);
            return Collections.emptyList();
        }
        this.metricsListener.didSenderDirFilesCount(files.length - 1);
        Arrays.sort(files, Comparator.comparing(File::getName));
        return Arrays.asList(files).subList(0, files.length - 1);
    }
}

