/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueSender;
import java.io.File;

public class TailQueueFileSenderContext {
    private final File file;
    private final int current;
    private final int count;
    private final ITailQueueSender sender;
    private final ITailQueueMetricsListener metricsListener;

    TailQueueFileSenderContext(File file, int current, int count, ITailQueueSender sender, ITailQueueMetricsListener metricsListener) {
        this.file = file;
        this.current = current;
        this.count = count;
        this.sender = sender;
        this.metricsListener = metricsListener;
    }

    public static TailQueueFileSenderContextBuilder builder() {
        return new TailQueueFileSenderContextBuilder();
    }

    public File getFile() {
        return this.file;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getCount() {
        return this.count;
    }

    public ITailQueueSender getSender() {
        return this.sender;
    }

    public ITailQueueMetricsListener getMetricsListener() {
        return this.metricsListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TailQueueFileSenderContext)) {
            return false;
        }
        TailQueueFileSenderContext other = (TailQueueFileSenderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        ITailQueueSender this$sender = this.getSender();
        ITailQueueSender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        ITailQueueMetricsListener this$metricsListener = this.getMetricsListener();
        ITailQueueMetricsListener other$metricsListener = other.getMetricsListener();
        return !(this$metricsListener == null ? other$metricsListener != null : !this$metricsListener.equals(other$metricsListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TailQueueFileSenderContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrent();
        result = result * 59 + this.getCount();
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        ITailQueueSender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        ITailQueueMetricsListener $metricsListener = this.getMetricsListener();
        result = result * 59 + ($metricsListener == null ? 43 : $metricsListener.hashCode());
        return result;
    }

    public String toString() {
        return "TailQueueFileSenderContext(file=" + this.getFile() + ", current=" + this.getCurrent() + ", count=" + this.getCount() + ", sender=" + this.getSender() + ", metricsListener=" + this.getMetricsListener() + ")";
    }

    public static class TailQueueFileSenderContextBuilder {
        private File file;
        private int current;
        private int count;
        private ITailQueueSender sender;
        private ITailQueueMetricsListener metricsListener;

        TailQueueFileSenderContextBuilder() {
        }

        public TailQueueFileSenderContextBuilder file(File file) {
            this.file = file;
            return this;
        }

        public TailQueueFileSenderContextBuilder current(int current) {
            this.current = current;
            return this;
        }

        public TailQueueFileSenderContextBuilder count(int count) {
            this.count = count;
            return this;
        }

        public TailQueueFileSenderContextBuilder sender(ITailQueueSender sender) {
            this.sender = sender;
            return this;
        }

        public TailQueueFileSenderContextBuilder metricsListener(ITailQueueMetricsListener metricsListener) {
            this.metricsListener = metricsListener;
            return this;
        }

        public TailQueueFileSenderContext build() {
            return new TailQueueFileSenderContext(this.file, this.current, this.count, this.sender, this.metricsListener);
        }

        public String toString() {
            return "TailQueueFileSenderContext.TailQueueFileSenderContextBuilder(file=" + this.file + ", current=" + this.current + ", count=" + this.count + ", sender=" + this.sender + ", metricsListener=" + this.metricsListener + ")";
        }
    }
}

