/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueWriterImpl
implements ITailQueueWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueWriterImpl.class);
    private final File dir;
    private final DateTimeFormatter dateFormatter;
    private final String filePrefix;
    private final String fileSuffix;
    private final ITailQueueMetricsListener tailQueueStat;

    public TailQueueWriterImpl(File dir, DateTimeFormatter dateFormatter, String filePrefix, String fileSuffix, ITailQueueMetricsListener tailQueueStat) {
        this.dir = dir;
        this.dateFormatter = dateFormatter;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.tailQueueStat = tailQueueStat;
    }

    @Override
    public synchronized void writeMessage(String aMessage) {
        if (aMessage == null || aMessage.isEmpty()) {
            return;
        }
        byte[] bytes = TailQueueWriterImpl.encodeToBytes(aMessage);
        File file = new File(this.dir, this.filePrefix + LocalDateTime.now().format(this.dateFormatter) + this.fileSuffix);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing to {}: {}", (Object)file.getAbsolutePath(), (Object)aMessage);
        }
        try (FileOutputStream out = new FileOutputStream(file, true);){
            out.write(bytes);
            out.flush();
            this.tailQueueStat.didWriteMessageSuccess();
        }
        catch (Exception e) {
            this.tailQueueStat.didWriteMessageError();
            LOG.error("Cannot write to file {} : {}", new Object[]{file.getAbsolutePath(), aMessage, e});
        }
    }

    private static byte[] encodeToBytes(String aMessage) {
        byte[] orig = aMessage.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream out = new ByteArrayOutputStream(orig.length + 1);
        for (byte b : orig) {
            if (b == 10 || b == 13) continue;
            out.write(b);
        }
        out.write(10);
        return out.toByteArray();
    }
}

