/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueSender;
import com.payneteasy.tailqueue.TailQueueRollCycle;
import com.payneteasy.tailqueue.impl.TailQueueMetricsListenerListenerNoOp;
import com.payneteasy.tailqueue.impl.TailQueueWriterImpl;
import com.payneteasy.tailqueue.impl.util.SafeFiles;
import java.io.File;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueSenderFailsafe
implements ITailQueueSender {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueSenderFailsafe.class);
    private final File failsafeDir;
    private final int attempts;
    private final Duration sleepBetweenAttempts;
    private final ITailQueueSender sender;
    private final TailQueueWriterImpl failWriter;

    public TailQueueSenderFailsafe(File failsafeDir, int attempts, Duration sleepBetweenAttempts, ITailQueueSender sender) {
        this.failsafeDir = failsafeDir;
        this.attempts = attempts;
        this.sleepBetweenAttempts = sleepBetweenAttempts;
        this.sender = sender;
        this.failWriter = new TailQueueWriterImpl(SafeFiles.mkDirs(failsafeDir), TailQueueRollCycle.MINUTELY.getDateFormatter(), "", ".json", new TailQueueMetricsListenerListenerNoOp());
    }

    @Override
    public void sendMessage(String aLine) {
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.sender.sendMessage(aLine);
                return;
            }
            catch (Exception e) {
                LOG.error("Cannot send line on {} / {} attempt: {}", new Object[]{i, this.attempts, aLine, e});
                try {
                    this.sleepBetweenAttempts();
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.error("Interrupted sleep between attempts");
                    break;
                }
            }
        }
        LOG.warn("Writing failed message to {} dir", (Object)this.failsafeDir.getAbsolutePath());
        this.failWriter.writeMessage(aLine);
    }

    private void sleepBetweenAttempts() throws InterruptedException {
        LOG.warn("Sleeping {} between attempts", (Object)this.sleepBetweenAttempts);
        Thread.sleep(this.sleepBetweenAttempts.toMillis());
    }
}

