/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueWriterImpl
implements ITailQueueWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueWriterImpl.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final File dir;
    private final DateTimeFormatter dateFormatter;
    private final String filePrefix;
    private final String fileSuffix;
    private final ITailQueueMetricsListener tailQueueStat;

    public TailQueueWriterImpl(File dir, DateTimeFormatter dateFormatter, String filePrefix, String fileSuffix, ITailQueueMetricsListener tailQueueStat) {
        this.dir = dir;
        this.dateFormatter = dateFormatter;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.tailQueueStat = tailQueueStat;
    }

    @Override
    public synchronized void writeMessage(String aMessage) {
        if (aMessage == null || aMessage.isEmpty()) {
            return;
        }
        byte[] bytes = TailQueueWriterImpl.encodeToBytes(aMessage);
        File file = new File(this.dir, this.filePrefix + LocalDateTime.now().format(this.dateFormatter) + this.fileSuffix);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing to {}: {}", (Object)file.getAbsolutePath(), (Object)aMessage);
        }
        try (FileOutputStream out = new FileOutputStream(file, true);){
            out.write(bytes);
            out.flush();
            this.tailQueueStat.didWriteMessageSuccess();
        }
        catch (Exception e) {
            this.tailQueueStat.didWriteMessageError();
            LOG.error("Cannot write to file {} : {}", new Object[]{file.getAbsolutePath(), aMessage, e});
        }
    }

    private static byte[] encodeToBytes(String aMessage) {
        String messageWithEndLine = TailQueueWriterImpl.removeNewLines(aMessage) + LINE_SEPARATOR;
        return messageWithEndLine.getBytes(StandardCharsets.UTF_8);
    }

    private static String removeNewLines(String aMessage) {
        return TailQueueWriterImpl.removeCharIfExists(TailQueueWriterImpl.removeCharIfExists(aMessage, "\r"), "\n");
    }

    private static String removeCharIfExists(String aMessage, String aSymbol) {
        if (aMessage.contains(aSymbol)) {
            return aMessage.replace(aSymbol, "");
        }
        return aMessage;
    }
}

