/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueue;
import com.payneteasy.tailqueue.ITailQueueWriter;
import com.payneteasy.tailqueue.impl.TailQueueSenderTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueImpl
implements ITailQueue {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueImpl.class);
    private final ITailQueueWriter writer;
    private final TailQueueSenderTask senderTask;
    private final Thread thread;

    public TailQueueImpl(ITailQueueWriter writer, TailQueueSenderTask senderTask) {
        this.writer = writer;
        this.senderTask = senderTask;
        this.thread = new Thread(senderTask);
    }

    @Override
    public ITailQueueWriter getWriter() {
        return this.writer;
    }

    @Override
    public void startQueueSender() {
        this.thread.start();
    }

    @Override
    public void shutdownQueueSender() {
        LOG.debug("Shutting down...");
        this.thread.interrupt();
    }
}

