/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue;

import com.payneteasy.tailqueue.ITailQueue;
import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueRetention;
import com.payneteasy.tailqueue.ITailQueueSender;
import com.payneteasy.tailqueue.TailQueueRollCycle;
import com.payneteasy.tailqueue.impl.TailQueueDirSender;
import com.payneteasy.tailqueue.impl.TailQueueFileFilter;
import com.payneteasy.tailqueue.impl.TailQueueFileTailer;
import com.payneteasy.tailqueue.impl.TailQueueImpl;
import com.payneteasy.tailqueue.impl.TailQueueMetricsListenerListenerNoOp;
import com.payneteasy.tailqueue.impl.TailQueueRetentionDeleteFile;
import com.payneteasy.tailqueue.impl.TailQueueSenderTask;
import com.payneteasy.tailqueue.impl.TailQueueWriterImpl;
import com.payneteasy.tailqueue.impl.util.SafeFiles;
import java.io.File;
import java.time.Duration;
import java.util.Objects;

public class TailQueueBuilder {
    private ITailQueueSender sender;
    private File dir;
    private TailQueueRollCycle rollCycle = TailQueueRollCycle.MINUTELY;
    private String filePrefix = "";
    private String fileSuffix = ".json";
    private ITailQueueMetricsListener metricsListener = new TailQueueMetricsListenerListenerNoOp();
    private ITailQueueRetention retention = new TailQueueRetentionDeleteFile();
    private Duration liveWaitDuration = Duration.ofMillis(500L);
    private Duration dirListWaitDuration = Duration.ofMillis(500L);

    public TailQueueBuilder sender(ITailQueueSender sender) {
        this.sender = sender;
        return this;
    }

    public TailQueueBuilder dir(File dir) {
        this.dir = dir;
        return this;
    }

    public TailQueueBuilder rollCycle(TailQueueRollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return this;
    }

    public TailQueueBuilder filePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
        return this;
    }

    public TailQueueBuilder fileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
        return this;
    }

    public TailQueueBuilder metricsListener(ITailQueueMetricsListener statListener) {
        this.metricsListener = statListener;
        return this;
    }

    public TailQueueBuilder retention(ITailQueueRetention retention) {
        this.retention = retention;
        return this;
    }

    public TailQueueBuilder liveWaitDuration(Duration liveWaitDuration) {
        this.liveWaitDuration = liveWaitDuration;
        return this;
    }

    public TailQueueBuilder dirListWaitDuration(Duration dirListWaitDuration) {
        this.dirListWaitDuration = dirListWaitDuration;
        return this;
    }

    public ITailQueue build() {
        Objects.requireNonNull(this.sender, "Sender is null");
        Objects.requireNonNull(this.dir, "Dir is null");
        SafeFiles.mkDirs(this.dir);
        TailQueueWriterImpl writer = new TailQueueWriterImpl(this.dir, this.rollCycle.getDateFormatter(), this.filePrefix, this.fileSuffix, this.metricsListener);
        TailQueueSenderTask senderTask = this.createSenderTask();
        return new TailQueueImpl(writer, senderTask);
    }

    private TailQueueSenderTask createSenderTask() {
        TailQueueFileFilter fileFilter = new TailQueueFileFilter(this.filePrefix, this.fileSuffix);
        TailQueueDirSender dirSender = new TailQueueDirSender(this.dir, fileFilter, this.sender, this.retention, this.metricsListener);
        TailQueueFileTailer fileTailer = new TailQueueFileTailer(this.dir, this.sender, fileFilter, this.liveWaitDuration, this.metricsListener);
        return new TailQueueSenderTask(this.dir, dirSender, fileTailer, this.dirListWaitDuration, this.metricsListener);
    }
}

