/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueWriterImpl
implements ITailQueueWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueWriterImpl.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final File dir;
    private final DateTimeFormatter dateFormatter;
    private final String filePrefix;
    private final String fileSuffix;
    private final ITailQueueMetricsListener tailQueueStat;

    public TailQueueWriterImpl(File dir, DateTimeFormatter dateFormatter, String filePrefix, String fileSuffix, ITailQueueMetricsListener tailQueueStat) {
        this.dir = dir;
        this.dateFormatter = dateFormatter;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.tailQueueStat = tailQueueStat;
    }

    @Override
    public synchronized void writeMessage(String aMessage) {
        File file = new File(this.dir, this.filePrefix + LocalDateTime.now().format(this.dateFormatter) + this.fileSuffix);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing to {}: {}", (Object)file.getAbsolutePath(), (Object)aMessage);
        }
        try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND, StandardOpenOption.CREATE), StandardCharsets.UTF_8);){
            out.write(aMessage);
            out.write(LINE_SEPARATOR);
            out.flush();
            this.tailQueueStat.didWriteMessageSuccess();
        }
        catch (Exception e) {
            this.tailQueueStat.didWriteMessageError();
            LOG.error("Cannot write to file {} : {}", new Object[]{file.getAbsolutePath(), aMessage, e});
        }
    }
}

