/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueRetention;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueRetentionArchiver
implements ITailQueueRetention {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueRetentionArchiver.class);
    private final File processedDir;

    public TailQueueRetentionArchiver(File processedDir) {
        this.processedDir = processedDir;
    }

    @Override
    public void archiveFile(File file) {
        File processedFile = new File(this.processedDir, file.getName() + ".gz");
        LOG.info("Archiving file {}  to {} ...", (Object)file.getAbsolutePath(), (Object)processedFile.getAbsolutePath());
        try {
            try (GZIPOutputStream out = new GZIPOutputStream(Files.newOutputStream(processedFile.toPath(), new OpenOption[0]));){
                Files.copy(file.toPath(), out);
            }
            if (!file.delete()) {
                LOG.error("Cannot delete file {}", (Object)file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOG.error("Cannot move file {} to {}", new Object[]{file.getAbsolutePath(), processedFile.getAbsolutePath(), e});
        }
    }
}

