/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.tailqueue.impl;

import com.payneteasy.tailqueue.ITailQueueMetricsListener;
import com.payneteasy.tailqueue.ITailQueueRetention;
import com.payneteasy.tailqueue.ITailQueueSender;
import com.payneteasy.tailqueue.impl.TailQueueFileFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailQueueDirSender {
    private static final Logger LOG = LoggerFactory.getLogger(TailQueueDirSender.class);
    private final File dir;
    private final TailQueueFileFilter fileFilter;
    private final ITailQueueSender sender;
    private final ITailQueueRetention retention;
    private final ITailQueueMetricsListener metricsListener;

    public TailQueueDirSender(File dir, TailQueueFileFilter fileFilter, ITailQueueSender sender, ITailQueueRetention retention, ITailQueueMetricsListener metricsListener) {
        this.dir = dir;
        this.fileFilter = fileFilter;
        this.sender = sender;
        this.retention = retention;
        this.metricsListener = metricsListener;
    }

    void processDir() {
        List<File> filesToProcess = this.createFileListForDirProcess();
        if (filesToProcess.isEmpty()) {
            LOG.trace("Files to process {}", (Object)filesToProcess.size());
        } else {
            LOG.debug("Files to process {}", (Object)filesToProcess.size());
        }
        for (int i = 0; i < filesToProcess.size(); ++i) {
            File file = filesToProcess.get(i);
            try {
                this.sendFile(file, i, filesToProcess.size());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot process file " + file.getAbsolutePath(), e);
            }
            try {
                this.archiveFile(file, i, filesToProcess.size());
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot archive file " + file.getAbsolutePath(), e);
            }
        }
    }

    private void archiveFile(File aFile, int current, int count) {
        LOG.debug("Archiving file ({}/{}) {}...", new Object[]{aFile, current, count});
        this.retention.archiveFile(aFile);
        this.metricsListener.didSenderDirArchiveFile();
    }

    private void sendFile(File aFile, int current, int count) throws IOException {
        LOG.debug("Sending file {} ...", (Object)aFile.getAbsolutePath());
        try (LineNumberReader in = new LineNumberReader(new InputStreamReader(Files.newInputStream(aFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                LOG.debug("Sending line {}:{} ({}/{})...", new Object[]{aFile.getName(), in.getLineNumber(), current, count});
                this.sender.sendMessage(line);
                this.metricsListener.didSenderDirSendLineSuccess();
            }
        }
        this.metricsListener.didSenderDirSendFile(current, count);
    }

    private List<File> createFileListForDirProcess() {
        File[] files = this.dir.listFiles(this.fileFilter);
        if (files == null || files.length == 0) {
            this.metricsListener.didSenderDirFilesCount(0);
            return Collections.emptyList();
        }
        this.metricsListener.didSenderDirFilesCount(files.length - 1);
        Arrays.sort(files, Comparator.comparing(File::getName));
        return Arrays.asList(files).subList(0, files.length - 1);
    }
}

