/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.startup.parameters.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ValueConverter {
    private final Map<Class, IConverter> map = new HashMap<Class, IConverter>();
    private final List<ITypedConverter> list;

    public ValueConverter() {
        this.map.put(Character.TYPE, aText -> Character.valueOf(aText.charAt(0)));
        this.map.put(Character.class, aText -> Character.valueOf(aText.charAt(0)));
        this.map.put(Boolean.class, Boolean::parseBoolean);
        this.map.put(Boolean.TYPE, Boolean::valueOf);
        this.map.put(Double.class, Double::parseDouble);
        this.map.put(Double.TYPE, Double::valueOf);
        this.map.put(Float.class, Float::parseFloat);
        this.map.put(Float.TYPE, Float::valueOf);
        this.map.put(Integer.TYPE, Integer::parseInt);
        this.map.put(Integer.class, Integer::valueOf);
        this.map.put(Long.TYPE, Long::parseLong);
        this.map.put(Long.class, Long::valueOf);
        this.map.put(Short.TYPE, Short::parseShort);
        this.map.put(Short.class, Short::valueOf);
        this.map.put(Byte.TYPE, Byte::parseByte);
        this.map.put(Byte.class, Byte::valueOf);
        this.map.put(String.class, aText -> aText);
        this.map.put(Period.class, Period::parse);
        this.map.put(Duration.class, Duration::parse);
        this.map.put(File.class, File::new);
        this.map.put(BigDecimal.class, BigDecimal::new);
        this.list = new ArrayList<ITypedConverter>();
        this.list.add((type, aText) -> {
            if (type.isEnum()) {
                Class classEnum = type;
                return Optional.of(Enum.valueOf(classEnum, aText));
            }
            return Optional.empty();
        });
    }

    Object convertValue(Class<?> type, String textValue, Method aMethod) {
        IConverter converter = this.map.get(type);
        if (converter != null) {
            return converter.convert(textValue);
        }
        for (ITypedConverter typedConverter : this.list) {
            Optional<?> optional = typedConverter.convert(type, textValue);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        throw new IllegalStateException("Type " + type + " is unsupported for method " + aMethod);
    }

    private static interface ITypedConverter {
        public Optional<?> convert(Class<?> var1, String var2);
    }

    private static interface IConverter {
        public Object convert(String var1);
    }
}

