/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.simplecache.cassandra.impl;

import com.google.gson.Gson;
import com.payneteasy.simplecache.cassandra.ICassandraPayloadCodec;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class CassandraPayloadCodecGson<T>
implements ICassandraPayloadCodec<T> {
    private final Gson gson;
    private final Class<T> clazz;

    public CassandraPayloadCodecGson(Gson gson, Class<T> clazz) {
        this.gson = gson;
        this.clazz = clazz;
    }

    @Override
    public T decode(ByteBuffer aBuffer) {
        byte[] bytes = aBuffer.array();
        String json = new String(bytes, StandardCharsets.UTF_8);
        return (T)this.gson.fromJson(json, this.clazz);
    }

    @Override
    public ByteBuffer encode(T aValue) {
        String json = this.gson.toJson(aValue);
        return ByteBuffer.wrap(json.getBytes(StandardCharsets.UTF_8));
    }
}

