/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.simplecache.cassandra.impl;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.payneteasy.simplecache.cassandra.ICassandraCache;
import com.payneteasy.simplecache.cassandra.ICassandraCacheMetricsListener;
import com.payneteasy.simplecache.cassandra.ICassandraPayloadCodec;
import com.payneteasy.simplecache.cassandra.UpsertCassandraException;
import com.payneteasy.simplecache.cassandra.impl.OperationTimer;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraCacheImpl<T>
implements ICassandraCache<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraCacheImpl.class);
    private final CqlSession session;
    private final ICassandraPayloadCodec<T> codec;
    private final PreparedStatement insertStmt;
    private final PreparedStatement updateStmt;
    private final PreparedStatement upsertStmt;
    private final PreparedStatement selectStmt;
    private final ICassandraCacheMetricsListener metricsListener;

    public CassandraCacheImpl(CqlSession session, ICassandraPayloadCodec<T> codec, PreparedStatement insertStmt, PreparedStatement updateStmt, PreparedStatement upsertStmt, PreparedStatement selectStmt, ICassandraCacheMetricsListener metricsListener) {
        this.session = session;
        this.codec = codec;
        this.insertStmt = insertStmt;
        this.updateStmt = updateStmt;
        this.upsertStmt = upsertStmt;
        this.selectStmt = selectStmt;
        this.metricsListener = metricsListener;
    }

    @Override
    public Optional<T> insert(String aKey, T aValue) {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void upsert(String aKey, T aValue) throws UpsertCassandraException {
        OperationTimer timer = new OperationTimer();
        ByteBuffer payload = this.codec.encode(aValue);
        LOG.debug("Inserting key {} ...", (Object)aKey);
        ResultSet rs = this.session.execute((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.upsertStmt.boundStatementBuilder(new Object[0]).setByteBuffer(0, payload)).setString(1, aKey)).setConsistencyLevel(ConsistencyLevel.QUORUM)).build());
        if (!rs.wasApplied()) {
            this.fire(ICassandraCacheMetricsListener.Type.UPSERT, false, timer);
            throw new UpsertCassandraException("Cannot upsert key " + aKey);
        }
        LOG.debug("Key inserted {} ...", (Object)aKey);
        this.fire(ICassandraCacheMetricsListener.Type.UPSERT, true, timer);
    }

    @Override
    public boolean update(String aKey, T aValue) {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public Optional<T> getIfPresent(String aKey) {
        OperationTimer timer = new OperationTimer();
        ResultSet rs = this.session.execute((Statement)((BoundStatementBuilder)((BoundStatementBuilder)this.selectStmt.boundStatementBuilder(new Object[0]).setString(0, aKey)).setConsistencyLevel(ConsistencyLevel.SERIAL)).build());
        Row row = (Row)rs.one();
        if (row == null) {
            LOG.debug("{}: no one row", (Object)aKey);
            this.fire(ICassandraCacheMetricsListener.Type.SELECT, false, timer);
            return Optional.empty();
        }
        ByteBuffer payload = row.getByteBuffer(0);
        if (payload == null) {
            LOG.debug("{}: payload is empty", (Object)aKey);
            this.fire(ICassandraCacheMetricsListener.Type.SELECT, false, timer);
            return Optional.empty();
        }
        T value = this.codec.decode(payload);
        this.fire(ICassandraCacheMetricsListener.Type.SELECT, true, timer);
        return Optional.of(value);
    }

    private void fire(ICassandraCacheMetricsListener.Type aType, boolean aSuccess, OperationTimer aTimer) {
        this.metricsListener.onEvent(aType, aSuccess, aTimer.getSeconds());
    }
}

