/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.simplecache.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.payneteasy.simplecache.cassandra.ICassandraCache;
import com.payneteasy.simplecache.cassandra.ICassandraCacheMetricsListener;
import com.payneteasy.simplecache.cassandra.ICassandraPayloadCodec;
import com.payneteasy.simplecache.cassandra.impl.CassandraCacheImpl;
import com.payneteasy.simplecache.cassandra.impl.CassandraCacheMetricsListenerNoOp;
import java.util.Objects;

public class CassandraCacheBuilder<T> {
    private String keyColumn;
    private String valueColumn;
    private String guardColumn;
    private String table;
    private CqlSession session;
    private ICassandraPayloadCodec<T> codec;
    private ICassandraCacheMetricsListener metricsListener = new CassandraCacheMetricsListenerNoOp();

    public CassandraCacheBuilder<T> keyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    public CassandraCacheBuilder<T> valueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
        return this;
    }

    public CassandraCacheBuilder<T> table(String table) {
        this.table = table;
        return this;
    }

    public CassandraCacheBuilder<T> session(CqlSession session) {
        this.session = session;
        return this;
    }

    public CassandraCacheBuilder<T> guardColumn(String guardColumn) {
        this.guardColumn = guardColumn;
        return this;
    }

    public CassandraCacheBuilder<T> codec(ICassandraPayloadCodec<T> codec) {
        this.codec = codec;
        return this;
    }

    public CassandraCacheBuilder<T> metrics(ICassandraCacheMetricsListener metricsListener) {
        this.metricsListener = metricsListener;
        return this;
    }

    public ICassandraCache<T> build() {
        Objects.requireNonNull(this.session, "No session");
        PreparedStatement select = this.session.prepare(this.format("select $VALUE from $TABLE where $KEY = ?"));
        PreparedStatement insert = this.session.prepare(this.format("insert into $TABLE ($KEY, $VALUE) values (?, ?) if not exists"));
        PreparedStatement update = this.session.prepare(this.format("update $TABLE set $VALUE = ? where $KEY = ? if exists"));
        PreparedStatement upsert = this.session.prepare(this.format("update $TABLE  set   $VALUE = ? where $KEY   = ? if    $GUARD = null"));
        return new CassandraCacheImpl<T>(this.session, Objects.requireNonNull(this.codec, "No codec"), insert, update, upsert, select, this.metricsListener);
    }

    private String format(String aTemplate) {
        return aTemplate.replace("$TABLE", Objects.requireNonNull(this.table, "No table")).replace("$KEY", Objects.requireNonNull(this.keyColumn, "No key column")).replace("$VALUE", Objects.requireNonNull(this.valueColumn, "No value column")).replace("$GUARD", Objects.requireNonNull(this.guardColumn, "No guard column"));
    }
}

