package com.payneteasy.simplecache.cassandra.impl;

import com.google.gson.Gson;
import com.payneteasy.simplecache.cassandra.ICassandraPayloadCodec;

import java.nio.ByteBuffer;

import static java.nio.charset.StandardCharsets.UTF_8;

public class CassandraPayloadCodecGson<T> implements ICassandraPayloadCodec<T> {

    private final Gson     gson;
    private final Class<T> clazz;

    public CassandraPayloadCodecGson(Gson gson, Class<T> clazz) {
        this.gson  = gson;
        this.clazz = clazz;
    }

    @Override
    public T decode(ByteBuffer aBuffer) {
        byte[] bytes = aBuffer.array();
        String json = new String(bytes, UTF_8);
        return gson.fromJson(json, clazz);
    }

    @Override
    public ByteBuffer encode(T aValue) {
        String json = gson.toJson(aValue);
        return ByteBuffer.wrap(json.getBytes(UTF_8));
    }
}
