/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.osprocess.impl;

import com.payneteasy.osprocess.api.IProcessListener;
import com.payneteasy.osprocess.api.ProcessRunResult;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Exchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListenerWaiter
implements IProcessListener {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorListenerWaiter.class);
    private final Queue<String> lines = new ConcurrentLinkedQueue<String>();
    private final Exchanger<ProcessRunResult> exchanger;

    public ProcessorListenerWaiter(Exchanger<ProcessRunResult> exchanger) {
        this.exchanger = exchanger;
    }

    public void onStandardOut(String aLine) {
        LOG.debug("onStandardOut: {}", (Object)aLine);
        this.lines.add(aLine);
    }

    public void onErrorOut(String aLine) {
        LOG.debug("onErrorOut: {}", (Object)aLine);
        this.lines.add(aLine);
    }

    public void onExit(int aExitCode) {
        LOG.debug("onExit: {}", (Object)aExitCode);
        try {
            this.exchanger.exchange(new ProcessRunResult(aExitCode, this.getLines()));
        }
        catch (InterruptedException e) {
            LOG.error("Cannot exchange", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private String getLines() throws InterruptedException {
        for (int i = 0; i < 10 && this.lines.isEmpty(); ++i) {
            LOG.warn("No any output from process. Sleeping 100 ms ...");
            Thread.sleep(100L);
        }
        StringBuilder sb = new StringBuilder();
        for (String line : this.lines) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    public synchronized void onReadError(IOException e) {
        if ("Stream closed".equals(e.getMessage())) {
            return;
        }
        this.lines.add("error: " + e);
    }
}

