/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.osprocess.impl;

import com.payneteasy.osprocess.api.IProcessListener;
import com.payneteasy.osprocess.api.IProcessService;
import com.payneteasy.osprocess.api.ProcessDescriptor;
import com.payneteasy.osprocess.api.ProcessEnvVariable;
import com.payneteasy.osprocess.api.ProcessException;
import com.payneteasy.osprocess.api.ProcessRunResult;
import com.payneteasy.osprocess.impl.ProcessOutputStreamReader;
import com.payneteasy.osprocess.impl.ProcessorListenerWaiter;
import com.payneteasy.osprocess.impl.Safe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImpl
implements IProcessService {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessServiceImpl.class);

    public ProcessServiceImpl() {
    }

    public ProcessServiceImpl(ExecutorService executor) {
    }

    public ProcessRunResult runProcess(ProcessDescriptor aDescriptor) throws ProcessException {
        Exchanger<ProcessRunResult> exchanger = new Exchanger<ProcessRunResult>();
        this.startProcess(aDescriptor, new ProcessorListenerWaiter(exchanger));
        try {
            return exchanger.exchange(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ProcessRunResult(-1, "Cannot exchange value");
        }
    }

    public Process startProcess(ProcessDescriptor aDescriptor, IProcessListener aListener) throws ProcessException {
        Process process;
        try {
            List<String> commandArray = this.createCommandArray(aDescriptor.getCommand(), aDescriptor.getArgs());
            LOG.debug("Executing {} with working dir {} and env {} ...", new Object[]{commandArray, aDescriptor.getWorkingDir(), aDescriptor.getEnvVariables()});
            process = this.putEnvVariables(new ProcessBuilder(commandArray), (List<ProcessEnvVariable>)aDescriptor.getEnvVariables()).directory(aDescriptor.getWorkingDir()).redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new ProcessException("Cannot run " + aDescriptor.getCommand(), (Throwable)e);
        }
        Thread inputThread = new Thread(new ProcessOutputStreamReader(process.getInputStream(), arg_0 -> ((IProcessListener)aListener).onStandardOut(arg_0), arg_0 -> ((IProcessListener)aListener).onReadError(arg_0)));
        Thread errorThread = new Thread(new ProcessOutputStreamReader(process.getInputStream(), arg_0 -> ((IProcessListener)aListener).onStandardOut(arg_0), arg_0 -> ((IProcessListener)aListener).onReadError(arg_0)));
        inputThread.start();
        errorThread.start();
        Thread waitingThread = new Thread(() -> {
            try {
                int result = process.waitFor();
                aListener.onExit(result);
            }
            catch (InterruptedException e) {
                LOG.error("Cannot execute process.waitFor(). Exiting with code -1", (Throwable)e);
                aListener.onExit(-1);
                Thread.currentThread().interrupt();
            }
        });
        waitingThread.start();
        return process;
    }

    private ProcessBuilder putEnvVariables(ProcessBuilder aProcessBuilder, List<ProcessEnvVariable> aVariables) {
        this.putEnvVariables(aProcessBuilder.environment(), aVariables);
        return aProcessBuilder;
    }

    private void putEnvVariables(Map<String, String> aMap, List<ProcessEnvVariable> aVariables) {
        for (ProcessEnvVariable variable : Safe.safeList(aVariables)) {
            aMap.put(variable.getName(), variable.getValue());
        }
    }

    private List<String> createCommandArray(String aCommand, List<String> aArgs) {
        if (aArgs == null) {
            return Collections.singletonList(aCommand);
        }
        ArrayList<String> command = new ArrayList<String>(aArgs.size() + 1);
        command.add(aCommand);
        command.addAll(aArgs);
        return command;
    }
}

