/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.jsonstore.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.payneteasy.mini.jsonstore.IFileLocator;
import com.payneteasy.mini.jsonstore.ISimpleStore;
import com.payneteasy.mini.jsonstore.NotFoundPromise;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class SimpleStoreGsonImpl<T>
implements ISimpleStore<T> {
    private final Class<T> type;
    private final IFileLocator fileLocator;
    private final Gson gson;
    private final Type listType;

    public SimpleStoreGsonImpl(Class<T> aType, IFileLocator aFileLocator, Gson aGson) {
        this.type = aType;
        this.fileLocator = aFileLocator;
        this.gson = aGson;
        this.listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{aType}).getType();
    }

    @Override
    public Optional<T> findFirst(Predicate<T> aPredicate) {
        return this.loadAll().stream().filter(aPredicate).findFirst();
    }

    @Override
    public List<T> listAll(Comparator<T> aComparator) {
        List<T> list = this.loadAll();
        list.sort(aComparator);
        return list;
    }

    @Override
    public void add(T aEntity) {
        List<T> list = this.loadAll();
        list.add(aEntity);
        this.save(list);
    }

    @Override
    public NotFoundPromise save(T aEntity, Predicate<T> aPredicate) {
        List<T> list = this.loadAll();
        for (int i = 0; i < list.size(); ++i) {
            T entry = list.get(i);
            if (!aPredicate.test(entry)) continue;
            list.set(i, aEntity);
            this.save(list);
            return NotFoundPromise.FOUND_PROMISE;
        }
        return NotFoundPromise.NOT_FOUND_PROMISE;
    }

    private void save(List<T> aList) {
        File file = this.fileLocator.locateFile();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.gson.toJson(aList, (Appendable)out);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write to " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public NotFoundPromise removeFirst(Predicate<T> aPredicate) {
        List<T> list = this.loadAll();
        boolean removed = list.removeIf(aPredicate);
        this.save(list);
        return removed ? NotFoundPromise.FOUND_PROMISE : NotFoundPromise.NOT_FOUND_PROMISE;
    }

    private List<T> loadAll() {
        List list;
        File file = this.fileLocator.locateFile();
        if (!file.exists()) {
            return new ArrayList();
        }
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            list = (List)this.gson.fromJson((Reader)in, this.listType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read from " + file.getAbsolutePath(), e);
            }
        }
        in.close();
        return list;
    }
}

