/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.jsonstore.impl;

import com.google.gson.Gson;
import com.payneteasy.mini.jsonstore.IFileLocator;
import com.payneteasy.mini.jsonstore.ILongIdStore;
import com.payneteasy.mini.jsonstore.impl.LongIdStoreImpl;
import com.payneteasy.mini.jsonstore.impl.SecurityContextFileLocator;
import com.payneteasy.mini.jsonstore.impl.SimpleStoreGsonImpl;
import java.io.File;
import java.util.function.Function;
import java.util.function.Supplier;

public class LongIdStoreBuilder<T> {
    private Class<T> type;
    private IFileLocator fileLocator;
    private Gson gson;
    private Function<T, Long> identity;

    public LongIdStoreBuilder(Class<T> type) {
        this.type = type;
    }

    public LongIdStoreBuilder<T> fileLocator(IFileLocator aLocator) {
        this.fileLocator = aLocator;
        return this;
    }

    public LongIdStoreBuilder<T> securityLocator(File aDir, String aFilename, Supplier<String> aUsernameFinder) {
        this.fileLocator = new SecurityContextFileLocator(aDir, aFilename, aUsernameFinder);
        return this;
    }

    public ILongIdStore<T> build() {
        SimpleStoreGsonImpl<T> storeGson = new SimpleStoreGsonImpl<T>(this.type, this.fileLocator, this.gson);
        return new LongIdStoreImpl<T>(storeGson, this.identity);
    }

    public LongIdStoreBuilder<T> gson(Gson aGson) {
        this.gson = aGson;
        return this;
    }

    public LongIdStoreBuilder<T> identity(Function<T, Long> aIdentity) {
        this.identity = aIdentity;
        return this;
    }
}

