/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.jsonfile;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFile<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFile.class);
    private final Gson gson;
    private final Type type;

    public JsonFile(Gson aGson, Class<T> type) {
        this.gson = aGson;
        this.type = type;
    }

    public JsonFile(Gson aGson, TypeToken<T> aTypeToken) {
        this.gson = aGson;
        this.type = aTypeToken.getType();
    }

    public void write(File aFile, T aValue) {
        LOG.debug("Writing to {}\n{} ...", (Object)aFile.getAbsolutePath(), aValue);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(aFile), StandardCharsets.UTF_8);){
            out.write(this.gson.toJson(aValue));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write to " + aFile.getAbsolutePath(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<T> read(File aFile) {
        if (!aFile.exists()) {
            LOG.debug("File not found: {}", (Object)aFile.getAbsolutePath());
            return Optional.empty();
        }
        try {
            LOG.debug("Reading from {} ...", (Object)aFile.getAbsolutePath());
            try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(aFile), StandardCharsets.UTF_8);){
                Optional<Object> optional = Optional.of(this.gson.fromJson((Reader)in, this.type));
                return optional;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read file " + aFile.getAbsolutePath(), e);
        }
    }
}

