/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.dao.factory;

import com.googlecode.jdbcproc.daofactory.StoredProcedureDaoFactoryBean;
import com.payneteasy.mini.dao.factory.IDaoFactory;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DaoFactoryImpl
implements IDaoFactory {
    private final StoredProcedureDaoFactoryBean beanFactory;
    private final DataSource dataSource;
    private final Closeable dataSourceCloseable;

    public DaoFactoryImpl(StoredProcedureDaoFactoryBean beanFactory, DataSource dataSource, Closeable dataSourceCloseable) {
        this.beanFactory = beanFactory;
        this.dataSource = dataSource;
        this.dataSourceCloseable = dataSourceCloseable;
    }

    @Override
    @NotNull
    public <T> T createDao(Class<T> aDaoClass) {
        try {
            this.beanFactory.setInterface(aDaoClass);
            return (T)this.beanFactory.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create " + String.valueOf(aDaoClass), e);
        }
    }

    @Override
    public void closeDataSource() {
        try {
            this.dataSourceCloseable.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close data source " + String.valueOf(this.dataSource), e);
        }
    }
}

