/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.dao.factory;

import com.googlecode.jdbcproc.daofactory.DaoMethodInfoFactory;
import com.googlecode.jdbcproc.daofactory.IMetaLoginInfoService;
import com.googlecode.jdbcproc.daofactory.StoredProcedureDaoFactoryBean;
import com.payneteasy.mini.dao.factory.DaoDatabaseConfig;
import com.payneteasy.mini.dao.factory.DaoFactoryImpl;
import com.payneteasy.mini.dao.factory.IDaoFactory;
import com.payneteasy.mini.dao.factory.IDaoStartupConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;

public class DaoFactoryBuilder {
    private IMetaLoginInfoService metaLoginInfoService;
    private DaoDatabaseConfig daoDatabaseConfig;

    public DaoFactoryBuilder daoStartupConfig(IDaoStartupConfig aConfig) {
        this.daoDatabaseConfig = DaoDatabaseConfig.builder().jdbcUrl(aConfig.jdbcUrl()).username(aConfig.jdbcUsername()).password(aConfig.jdbcPassword()).connectionInitQuery(aConfig.jdbcConnectionInitQuery()).build();
        return this;
    }

    public DaoFactoryBuilder daoDatabaseConfig(DaoDatabaseConfig aConfig) {
        this.daoDatabaseConfig = aConfig;
        return this;
    }

    public DaoFactoryBuilder metaLoginInfoService(IMetaLoginInfoService aLoginService) {
        this.metaLoginInfoService = aLoginService;
        return this;
    }

    public IDaoFactory build() {
        HikariDataSource dataSource = new HikariDataSource(DaoFactoryBuilder.createHikariConfig(this.daoDatabaseConfig));
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource((DataSource)dataSource);
        DaoMethodInfoFactory daoMethodFactory = new DaoMethodInfoFactory();
        daoMethodFactory.setJdbcTemplate(jdbcTemplate);
        daoMethodFactory.setMetaLoginInfoService(this.metaLoginInfoService);
        try {
            daoMethodFactory.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot init dao factory to " + this.daoDatabaseConfig.getJdbcUrl(), e);
        }
        StoredProcedureDaoFactoryBean beanFactory = new StoredProcedureDaoFactoryBean();
        beanFactory.setDaoMethodInfoFactory(daoMethodFactory);
        beanFactory.setJdbcTemplate(jdbcTemplate);
        return new DaoFactoryImpl(beanFactory, (DataSource)dataSource, (Closeable)dataSource);
    }

    @NotNull
    private static HikariConfig createHikariConfig(DaoDatabaseConfig aConfig) {
        HikariConfig poolConfig = new HikariConfig();
        poolConfig.setAutoCommit(true);
        poolConfig.setConnectionTestQuery(aConfig.getConnectionInitQuery());
        poolConfig.setJdbcUrl(aConfig.getJdbcUrl());
        poolConfig.setUsername(aConfig.getUsername());
        poolConfig.setPassword(aConfig.getPassword());
        return poolConfig;
    }
}

