/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.core.error.model;

import com.payneteasy.mini.core.error.model.IError;
import io.swagger.v3.oas.annotations.media.Schema;

public class InternalSystemError
implements IError {
    @Schema(description="Unique number assigned by the system to identify error", example="cc54bdd4-a57a-4683-8510-d1250218a813")
    private final String errorCorrelationId;
    @Schema(description="The error code", example="1234")
    private final int errorCode;
    @Schema(description="Description of the error", example="Internal error")
    private final String errorMessage;

    @Override
    public int getHttpReasonCode() {
        return 500;
    }

    InternalSystemError(String errorCorrelationId, int errorCode, String errorMessage) {
        this.errorCorrelationId = errorCorrelationId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static InternalSystemErrorBuilder builder() {
        return new InternalSystemErrorBuilder();
    }

    public String getErrorCorrelationId() {
        return this.errorCorrelationId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalSystemError)) {
            return false;
        }
        InternalSystemError other = (InternalSystemError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorCorrelationId = this.getErrorCorrelationId();
        String other$errorCorrelationId = other.getErrorCorrelationId();
        if (this$errorCorrelationId == null ? other$errorCorrelationId != null : !this$errorCorrelationId.equals(other$errorCorrelationId)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InternalSystemError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCorrelationId = this.getErrorCorrelationId();
        result = result * 59 + ($errorCorrelationId == null ? 43 : $errorCorrelationId.hashCode());
        result = result * 59 + this.getErrorCode();
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "InternalSystemError(errorCorrelationId=" + this.getErrorCorrelationId() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public static class InternalSystemErrorBuilder {
        private String errorCorrelationId;
        private int errorCode;
        private String errorMessage;

        InternalSystemErrorBuilder() {
        }

        public InternalSystemErrorBuilder errorCorrelationId(String errorCorrelationId) {
            this.errorCorrelationId = errorCorrelationId;
            return this;
        }

        public InternalSystemErrorBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public InternalSystemErrorBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public InternalSystemError build() {
            return new InternalSystemError(this.errorCorrelationId, this.errorCode, this.errorMessage);
        }

        public String toString() {
            return "InternalSystemError.InternalSystemErrorBuilder(errorCorrelationId=" + this.errorCorrelationId + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

