/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.core.error.model;

import com.payneteasy.mini.core.error.model.IError;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.annotation.Nullable;

public class BadRequestError
implements IError {
    @Schema(description="Unique number assigned by the system to identify error", example="cc54bdd4-a57a-4683-8510-d1250218a813")
    private final String errorCorrelationId;
    @Schema(description="The error code", example="1234")
    private final int errorCode;
    @Schema(description="Description of the error", example="No Authorization header")
    private final String errorMessage;
    @Nullable
    @Schema(description="List of bad input parameters")
    private final List<InvalidParam> invalidParams;

    @Override
    public int getHttpReasonCode() {
        return 400;
    }

    BadRequestError(String errorCorrelationId, int errorCode, String errorMessage, @Nullable List<InvalidParam> invalidParams) {
        this.errorCorrelationId = errorCorrelationId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.invalidParams = invalidParams;
    }

    public static BadRequestErrorBuilder builder() {
        return new BadRequestErrorBuilder();
    }

    public String getErrorCorrelationId() {
        return this.errorCorrelationId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public List<InvalidParam> getInvalidParams() {
        return this.invalidParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BadRequestError)) {
            return false;
        }
        BadRequestError other = (BadRequestError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorCorrelationId = this.getErrorCorrelationId();
        String other$errorCorrelationId = other.getErrorCorrelationId();
        if (this$errorCorrelationId == null ? other$errorCorrelationId != null : !this$errorCorrelationId.equals(other$errorCorrelationId)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        List<InvalidParam> this$invalidParams = this.getInvalidParams();
        List<InvalidParam> other$invalidParams = other.getInvalidParams();
        return !(this$invalidParams == null ? other$invalidParams != null : !((Object)this$invalidParams).equals(other$invalidParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BadRequestError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCorrelationId = this.getErrorCorrelationId();
        result = result * 59 + ($errorCorrelationId == null ? 43 : $errorCorrelationId.hashCode());
        result = result * 59 + this.getErrorCode();
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        List<InvalidParam> $invalidParams = this.getInvalidParams();
        result = result * 59 + ($invalidParams == null ? 43 : ((Object)$invalidParams).hashCode());
        return result;
    }

    public String toString() {
        return "BadRequestError(errorCorrelationId=" + this.getErrorCorrelationId() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", invalidParams=" + this.getInvalidParams() + ")";
    }

    public static class BadRequestErrorBuilder {
        private String errorCorrelationId;
        private int errorCode;
        private String errorMessage;
        private List<InvalidParam> invalidParams;

        BadRequestErrorBuilder() {
        }

        public BadRequestErrorBuilder errorCorrelationId(String errorCorrelationId) {
            this.errorCorrelationId = errorCorrelationId;
            return this;
        }

        public BadRequestErrorBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public BadRequestErrorBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public BadRequestErrorBuilder invalidParams(@Nullable List<InvalidParam> invalidParams) {
            this.invalidParams = invalidParams;
            return this;
        }

        public BadRequestError build() {
            return new BadRequestError(this.errorCorrelationId, this.errorCode, this.errorMessage, this.invalidParams);
        }

        public String toString() {
            return "BadRequestError.BadRequestErrorBuilder(errorCorrelationId=" + this.errorCorrelationId + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", invalidParams=" + this.invalidParams + ")";
        }
    }

    public static class InvalidParam {
        @Schema(description="Field name")
        private final String name;
        @Schema(description="Reason for error")
        private final String reason;

        InvalidParam(String name, String reason) {
            this.name = name;
            this.reason = reason;
        }

        public static InvalidParamBuilder builder() {
            return new InvalidParamBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvalidParam)) {
                return false;
            }
            InvalidParam other = (InvalidParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvalidParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }

        public String toString() {
            return "BadRequestError.InvalidParam(name=" + this.getName() + ", reason=" + this.getReason() + ")";
        }

        public static class InvalidParamBuilder {
            private String name;
            private String reason;

            InvalidParamBuilder() {
            }

            public InvalidParamBuilder name(String name) {
                this.name = name;
                return this;
            }

            public InvalidParamBuilder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public InvalidParam build() {
                return new InvalidParam(this.name, this.reason);
            }

            public String toString() {
                return "BadRequestError.InvalidParam.InvalidParamBuilder(name=" + this.name + ", reason=" + this.reason + ")";
            }
        }
    }
}

