/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.core.error.model;

import com.payneteasy.mini.core.error.model.IError;
import io.swagger.v3.oas.annotations.media.Schema;

public class UnauthorizedError
implements IError {
    @Schema(description="Unique number assigned by the system to identify error", example="cc54bdd4-a57a-4683-8510-d1250218a813")
    private final String errorCorrelationId;
    @Schema(description="Description of the error", example="Internal error")
    private final String errorMessage;
    @Schema(description="The error code", example="1234")
    private final int errorCode;

    @Override
    public int getHttpReasonCode() {
        return 401;
    }

    UnauthorizedError(String errorCorrelationId, String errorMessage, int errorCode) {
        this.errorCorrelationId = errorCorrelationId;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    public static UnauthorizedErrorBuilder builder() {
        return new UnauthorizedErrorBuilder();
    }

    public String getErrorCorrelationId() {
        return this.errorCorrelationId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnauthorizedError)) {
            return false;
        }
        UnauthorizedError other = (UnauthorizedError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorCorrelationId = this.getErrorCorrelationId();
        String other$errorCorrelationId = other.getErrorCorrelationId();
        if (this$errorCorrelationId == null ? other$errorCorrelationId != null : !this$errorCorrelationId.equals(other$errorCorrelationId)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        return this.getErrorCode() == other.getErrorCode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnauthorizedError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCorrelationId = this.getErrorCorrelationId();
        result = result * 59 + ($errorCorrelationId == null ? 43 : $errorCorrelationId.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        result = result * 59 + this.getErrorCode();
        return result;
    }

    public String toString() {
        return "UnauthorizedError(errorCorrelationId=" + this.getErrorCorrelationId() + ", errorMessage=" + this.getErrorMessage() + ", errorCode=" + this.getErrorCode() + ")";
    }

    public static class UnauthorizedErrorBuilder {
        private String errorCorrelationId;
        private String errorMessage;
        private int errorCode;

        UnauthorizedErrorBuilder() {
        }

        public UnauthorizedErrorBuilder errorCorrelationId(String errorCorrelationId) {
            this.errorCorrelationId = errorCorrelationId;
            return this;
        }

        public UnauthorizedErrorBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public UnauthorizedErrorBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public UnauthorizedError build() {
            return new UnauthorizedError(this.errorCorrelationId, this.errorMessage, this.errorCode);
        }

        public String toString() {
            return "UnauthorizedError.UnauthorizedErrorBuilder(errorCorrelationId=" + this.errorCorrelationId + ", errorMessage=" + this.errorMessage + ", errorCode=" + this.errorCode + ")";
        }
    }
}

