/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.core.error.handler;

import com.payneteasy.apiservlet.IRequestValidator;
import com.payneteasy.mini.core.error.exception.ApiBadRequestErrorException;
import com.payneteasy.mini.core.error.model.BadRequestError;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;

public class ApiRequestValidator
implements IRequestValidator {
    private final Validator validator;

    public ApiRequestValidator() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            this.validator = factory.getValidator();
        }
    }

    public <T> T validateRequest(T aRequest) {
        if (aRequest == null) {
            throw new ApiBadRequestErrorException(BadRequestError.builder().errorCorrelationId(UUID.randomUUID().toString()).errorCode(-7).errorMessage("No json body given").build());
        }
        Set validationResult = this.validator.validate(aRequest, new Class[0]);
        ArrayList<BadRequestError.InvalidParam> invalidParams = new ArrayList<BadRequestError.InvalidParam>();
        if (validationResult.size() > 0) {
            for (ConstraintViolation violation : validationResult) {
                invalidParams.add(BadRequestError.InvalidParam.builder().name(violation.getPropertyPath() + "").reason(violation.getMessage()).build());
            }
            throw new ApiBadRequestErrorException(BadRequestError.builder().errorCorrelationId(UUID.randomUUID().toString()).errorCode(-1).errorMessage("Bad Parameters in request").invalidParams(invalidParams).build());
        }
        return aRequest;
    }
}

