/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.mini.core.error.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.payneteasy.apiservlet.IExceptionContext;
import com.payneteasy.apiservlet.IExceptionHandler;
import com.payneteasy.mini.core.error.exception.ApiErrorException;
import com.payneteasy.mini.core.error.model.BadRequestError;
import com.payneteasy.mini.core.error.model.IError;
import com.payneteasy.mini.core.error.model.InternalSystemError;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExceptionHandler
implements IExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApiExceptionHandler.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void handleException(Exception e, IExceptionContext aContext) {
        IError error;
        if (e instanceof ApiErrorException) {
            ApiErrorException errorException = (ApiErrorException)e;
            error = errorException.getError();
        } else {
            error = e instanceof JsonSyntaxException ? BadRequestError.builder().errorMessage("Bad incoming json: " + e.getMessage()).errorCorrelationId(UUID.randomUUID().toString()).build() : InternalSystemError.builder().errorCode(-3).errorMessage("Unknown error").errorCorrelationId(UUID.randomUUID().toString()).build();
        }
        HttpServletResponse response = aContext.getHttpResponse();
        response.setStatus(error.getHttpReasonCode());
        response.setHeader("Content-Type", "application/json; charset=utf-8");
        LOG.error("Error is {}", (Object)error, (Object)e);
        try {
            response.getWriter().write(this.gson.toJson((Object)error));
        }
        catch (IOException ex) {
            LOG.error("Cannot write error", (Throwable)ex);
        }
    }
}

