/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import com.payneteasy.jetty.util.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlParametersBuilder {
    private final StringBuilder sb = new StringBuilder();
    private State state;

    public UrlParametersBuilder(String aUrl) {
        this.sb.append(aUrl);
        this.state = State.URL_ADDED;
    }

    public UrlParametersBuilder add(String aName, long aValue) {
        return this.add(aName, String.valueOf(aValue));
    }

    public UrlParametersBuilder addOnlyWithValue(String aName, String aValue) {
        if (Strings.isEmpty(aValue)) {
            return this;
        }
        return this.add(aName, aValue);
    }

    public UrlParametersBuilder add(String aName, String aValue) {
        switch (this.state.ordinal()) {
            case 0: {
                this.sb.append('?');
                this.state = State.FIRST_ADDED;
                break;
            }
            case 1: {
                this.sb.append('&');
            }
        }
        this.sb.append(this.urlEncode(aName));
        this.sb.append('=');
        this.sb.append(this.urlEncode(aValue));
        return this;
    }

    private String urlEncode(String aValue) {
        try {
            return URLEncoder.encode(aValue, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot encode url", e);
        }
    }

    public String build() {
        return this.sb.toString();
    }

    private static enum State {
        URL_ADDED,
        FIRST_ADDED;

    }
}

