/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUtils.class);

    public static String getRequestBody(HttpServletRequest request) {
        String result = null;
        try {
            result = RequestUtils.getString((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static String getString(InputStream inputStream) {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            int bytesRead;
            char[] charBuffer = new char[128];
            while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                stringBuilder.append(charBuffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return stringBuilder.toString();
    }
}

