/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util.error;

import com.payneteasy.jetty.util.Strings;
import com.payneteasy.jetty.util.error.HttpErrorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class HttpErrorContext {
    public static final HttpErrorContext EMPTY_CONTEXT = new HttpErrorContext("empty");
    private final List<HttpErrorItem> userItems = new ArrayList<HttpErrorItem>();
    private final List<HttpErrorItem> sysItems = new ArrayList<HttpErrorItem>();
    private final String internalMessage;
    private String friendlyMessage;
    private Throwable cause;
    private final String traceId = UUID.randomUUID().toString();

    private HttpErrorContext(String aInternal) {
        this.internalMessage = aInternal;
    }

    public HttpErrorContext friendly(String aFriendly) {
        this.friendlyMessage = aFriendly;
        return this;
    }

    public HttpErrorContext cause(Throwable aCause) {
        this.cause = aCause;
        return this;
    }

    public HttpErrorContext user(String aKey, String aValue) {
        this.userItems.add(new HttpErrorItem(aKey, aValue));
        return this;
    }

    public static HttpErrorContext errorCtx(String aId) {
        return new HttpErrorContext(aId);
    }

    public static HttpErrorContext errorCtx(String aId, Throwable cause) {
        return new HttpErrorContext(aId).cause(cause);
    }

    public HttpErrorContext sys(String aKey, String aValue) {
        this.sysItems.add(new HttpErrorItem(aKey, aValue));
        return this;
    }

    public List<HttpErrorItem> getUserItems() {
        return this.userItems;
    }

    public List<HttpErrorItem> getSysItems() {
        return this.sysItems;
    }

    public String getInternalMessage() {
        return this.internalMessage;
    }

    public String getFriendlyMessage() {
        return this.friendlyMessage;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public HttpErrorContext friendlySame() {
        return this.friendly(this.internalMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpErrorContext {");
        if (!this.userItems.isEmpty()) {
            sb.append("\n");
            sb.append("userItems=").append(this.userItems);
        }
        if (!this.sysItems.isEmpty()) {
            sb.append("\n");
            sb.append(", sysItems=").append(this.sysItems);
        }
        if (Strings.hasText(this.internalMessage)) {
            sb.append("\n");
            sb.append(", internalMessage='").append(this.internalMessage).append('\'');
        }
        if (Strings.hasText(this.friendlyMessage)) {
            sb.append("\n");
            sb.append(", friendlyMessage='").append(this.friendlyMessage).append('\'');
        }
        sb.append("\n");
        sb.append(", traceId='").append(this.traceId).append('\'');
        sb.append("\n");
        sb.append('}');
        return sb.toString();
    }
}

