/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import com.payneteasy.jetty.util.Strings;
import com.payneteasy.jetty.util.error.HttpErrorContext;
import com.payneteasy.jetty.util.error.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeServletResponse {
    private static final Logger LOG = LoggerFactory.getLogger(SafeServletResponse.class);
    private final String url;
    private final HttpServletResponse delegate;

    public SafeServletResponse(String aUrl, HttpServletResponse delegate) {
        this.url = aUrl;
        this.delegate = delegate;
    }

    public void showErrorPage(int aStatusCode, String aMessage) {
        this.delegate.setStatus(aStatusCode);
        try {
            this.delegate.getWriter().println(aMessage);
        }
        catch (IOException e) {
            LOG.error("Cannot write", (Throwable)e);
            throw new InternalErrorException(HttpErrorContext.errorCtx("Cannot write to output stream", e).sys("statusCode", "" + aStatusCode).sys("message", aMessage).sys("url", this.url));
        }
    }

    public void copyFrom(InputStream aInput) {
        byte[] buf = new byte[4096];
        try {
            int count;
            ServletOutputStream out = this.delegate.getOutputStream();
            while ((count = aInput.read(buf)) >= 0) {
                out.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot copy input stream", (Throwable)e);
        }
    }

    public void writeBytes(byte[] aBytes) {
        try {
            this.delegate.getOutputStream().write(aBytes);
        }
        catch (IOException e) {
            LOG.error("Cannot write bytes", (Throwable)e);
        }
    }

    public void writeChunk(String aText) {
        try {
            ServletOutputStream out = this.delegate.getOutputStream();
            out.println(aText);
            out.flush();
            this.delegate.flushBuffer();
        }
        catch (IOException e) {
            LOG.error("Cannot write", (Throwable)e);
        }
    }

    public void write(String aText) {
        try {
            this.delegate.getOutputStream().print(aText);
        }
        catch (IOException e) {
            LOG.error("Cannot write", (Throwable)e);
        }
    }

    public void setContentType(String aContentType) {
        this.delegate.setContentType(aContentType);
    }

    public void setHeader(String aName, String aValue) {
        this.delegate.setHeader(aName, aValue);
    }

    public void setStatus(int sc) {
        this.delegate.setStatus(sc);
    }

    public Writer getWriter() {
        try {
            return this.delegate.getWriter();
        }
        catch (IOException e) {
            throw new InternalErrorException(HttpErrorContext.errorCtx("Cannot get writer", e).friendly("Cannot write to output").sys("url", this.url));
        }
    }

    public void sendRedirect(String aUrl) {
        if (Strings.isEmpty(aUrl)) {
            throw new InternalErrorException(HttpErrorContext.errorCtx("URL for redirect is empty").friendlySame().sys("url", this.url));
        }
        try {
            this.delegate.sendRedirect(aUrl);
        }
        catch (IOException e) {
            LOG.error("Cannot send redirect to {}", (Object)aUrl, (Object)e);
            throw new InternalErrorException(HttpErrorContext.errorCtx("Cannot send redirect").friendly("Cannot send redirect to " + aUrl).sys("redirectUrl", aUrl).sys("url", this.url));
        }
    }
}

