/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import com.payneteasy.jetty.util.IRequestParameters;
import com.payneteasy.jetty.util.RequestUtils;
import com.payneteasy.jetty.util.SafeParameters;
import com.payneteasy.jetty.util.Strings;
import com.payneteasy.jetty.util.error.BadRequestException;
import com.payneteasy.jetty.util.error.HttpErrorContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SafeServletRequest
implements IRequestParameters {
    private final HttpServletRequest delegate;

    public SafeServletRequest(HttpServletRequest delegate) {
        this.delegate = delegate;
    }

    public long getRequiredLongParameter(String aName) {
        return Long.parseLong(this.getRequiredStringParameter(aName));
    }

    public int getIntParameter(String aName, int aDefaultValue) {
        String value = this.delegate.getParameter(aName);
        return Strings.isEmpty(value) ? aDefaultValue : Integer.parseInt(value);
    }

    public String getRequiredStringParameter(String aName) {
        String value = this.delegate.getParameter(aName);
        if (Strings.isEmpty(value)) {
            throw new BadRequestException(HttpErrorContext.errorCtx("Required parameter is empty").friendly("No value for parameter " + aName).user("parameter", aName));
        }
        return value;
    }

    public String getRequestBody() {
        return RequestUtils.getRequestBody(this.delegate);
    }

    public String getStringParameter(String aName, String aDefault) {
        String value = this.delegate.getParameter(aName);
        return Strings.isEmpty(value) ? aDefault : value;
    }

    @Override
    public String getStringParameter(String aName) {
        return this.delegate.getParameter(aName);
    }

    public String getRemoteIpAddress() {
        return this.delegate.getRemoteAddr();
    }

    public String getRemoteHostname() {
        return this.delegate.getRemoteHost();
    }

    public String getRequestUrl() {
        return this.delegate.getRequestURL().toString();
    }

    public boolean hasHeader(String aName) {
        return Strings.hasText(this.delegate.getHeader(aName));
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = this.delegate.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            headers.put(header, this.delegate.getHeader(header));
        }
        return headers;
    }

    public List<String> getParameterNames() {
        ArrayList<String> parameters = new ArrayList<String>();
        Enumeration en = this.delegate.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            parameters.add(name);
        }
        return parameters;
    }

    public Optional<HttpSession> getHttpSession(boolean aCreate) {
        return Optional.ofNullable(this.delegate.getSession(aCreate));
    }

    public SafeParameters getParameters() {
        return new SafeParameters(this);
    }

    public HttpServletRequest getDelegate() {
        return this.delegate;
    }
}

