/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.server.handler.StatisticsHandler;

public class JettyStatisticsCollectorEe8
extends Collector {
    private final StatisticsHandler statisticsHandler;
    private static final List<String> EMPTY_LIST = new ArrayList<String>();

    public JettyStatisticsCollectorEe8(StatisticsHandler statisticsHandler) {
        this.statisticsHandler = statisticsHandler;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(JettyStatisticsCollectorEe8.buildCounter("jetty_requests_total", "Number of requests", this.statisticsHandler.getRequestTotal()), JettyStatisticsCollectorEe8.buildGauge("jetty_requests_active", "Number of requests currently active", this.statisticsHandler.getRequestsActive()), JettyStatisticsCollectorEe8.buildGauge("jetty_requests_active_max", "Maximum number of requests that have been active at once", this.statisticsHandler.getRequestsActiveMax()), JettyStatisticsCollectorEe8.buildGauge("jetty_request_time_max_seconds", "Maximum time spent handling requests", (double)this.statisticsHandler.getRequestTimeMax() / 1000.0), JettyStatisticsCollectorEe8.buildCounter("jetty_request_time_seconds_total", "Total time spent in all request handling", (double)this.statisticsHandler.getRequestTimeTotal() / 1000.0), this.buildStatusCounter(), JettyStatisticsCollectorEe8.buildGauge("jetty_stats_seconds", "Time in seconds stats have been collected for", (double)this.statisticsHandler.getStatisticsDuration().toMillis() / 1000.0), JettyStatisticsCollectorEe8.buildCounter("jetty_responses_bytes_total", "Total number of bytes across all responses", this.statisticsHandler.getBytesWritten()), JettyStatisticsCollectorEe8.buildCounter("jetty_requests_bytes_total", "Total number of bytes across all responses", this.statisticsHandler.getBytesRead()));
    }

    private static Collector.MetricFamilySamples buildGauge(String name, String help, double value) {
        return new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, help, Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, EMPTY_LIST, EMPTY_LIST, value)));
    }

    private static Collector.MetricFamilySamples buildCounter(String name, String help, double value) {
        return new Collector.MetricFamilySamples(name, Collector.Type.COUNTER, help, Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, EMPTY_LIST, EMPTY_LIST, value)));
    }

    private Collector.MetricFamilySamples buildStatusCounter() {
        String name = "jetty_responses_total";
        return new Collector.MetricFamilySamples(name, Collector.Type.COUNTER, "Number of requests with response status", Arrays.asList(JettyStatisticsCollectorEe8.buildStatusSample(name, "1xx", this.statisticsHandler.getResponses1xx()), JettyStatisticsCollectorEe8.buildStatusSample(name, "2xx", this.statisticsHandler.getResponses2xx()), JettyStatisticsCollectorEe8.buildStatusSample(name, "3xx", this.statisticsHandler.getResponses3xx()), JettyStatisticsCollectorEe8.buildStatusSample(name, "4xx", this.statisticsHandler.getResponses4xx()), JettyStatisticsCollectorEe8.buildStatusSample(name, "5xx", this.statisticsHandler.getResponses5xx())));
    }

    private static Collector.MetricFamilySamples.Sample buildStatusSample(String name, String status, double value) {
        return new Collector.MetricFamilySamples.Sample(name, Collections.singletonList("code"), Collections.singletonList(status), value);
    }
}

