/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JettyContextBuilder.class);
    private final ServletContextHandler contextHandler;

    public JettyContextBuilder(ServletContextHandler aContext) {
        this.contextHandler = aContext;
    }

    public JettyContextBuilder servlet(String aPath, HttpServlet aServlet) {
        this.contextHandler.addServlet(new ServletHolder((Servlet)aServlet), aPath);
        LOG.info("Adding servlet [{}, {}]", (Object)aPath, (Object)aServlet.getClass().getSimpleName());
        return this;
    }

    public JettyContextBuilder filter(String aPath, Filter aFilter) {
        LOG.info("Adding filter [{}, {}]", (Object)aPath, (Object)aFilter.getClass().getSimpleName());
        this.contextHandler.addFilter(new FilterHolder(aFilter), aPath, EnumSet.of(DispatcherType.REQUEST));
        return this;
    }
}

