/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import com.payneteasy.jetty.util.IRequestParameters;
import com.payneteasy.jetty.util.RequestUtils;
import com.payneteasy.jetty.util.Strings;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SafeServletRequest
implements IRequestParameters {
    private final HttpServletRequest delegate;

    public SafeServletRequest(HttpServletRequest delegate) {
        this.delegate = delegate;
    }

    public long getRequiredLongParameter(String aName) {
        return Long.parseLong(this.getRequiredStringParameter(aName));
    }

    public int getIntParameter(String aName, int aDefaultValue) {
        String value = this.delegate.getParameter(aName);
        return Strings.isEmpty(value) ? aDefaultValue : Integer.parseInt(value);
    }

    public String getRequiredStringParameter(String aName) {
        String value = this.delegate.getParameter(aName);
        if (Strings.isEmpty(value)) {
            throw new IllegalStateException("No value for parameter " + aName);
        }
        return value;
    }

    public String getRequestBody() {
        return RequestUtils.getRequestBody(this.delegate);
    }

    public String getStringParameter(String aName, String aDefault) {
        String value = this.delegate.getParameter(aName);
        return Strings.isEmpty(value) ? aDefault : value;
    }

    @Override
    public String getStringParameter(String aName) {
        return this.delegate.getParameter(aName);
    }

    public String getRemoteIpAddress() {
        return this.delegate.getRemoteAddr();
    }

    public String getRemoteHostname() {
        return this.delegate.getRemoteHost();
    }

    public String getRequestUrl() {
        return this.delegate.getRequestURL().toString();
    }

    public boolean hasHeader(String aName) {
        return Strings.hasText(this.delegate.getHeader(aName));
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = this.delegate.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            headers.put(header, this.delegate.getHeader(header));
        }
        return headers;
    }

    public List<String> getParameterNames() {
        ArrayList<String> parameters = new ArrayList<String>();
        Enumeration en = this.delegate.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            parameters.add(name);
        }
        return parameters;
    }
}

