/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreventStackTraceFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PreventStackTraceFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            long id = System.currentTimeMillis();
            LOG.error("Error while processing trace {}", (Object)id, (Object)e);
            try {
                response.getOutputStream().println("Error " + id);
            }
            catch (IOException e1) {
                LOG.error("Cannot write error", (Throwable)e1);
            }
        }
    }

    public void destroy() {
    }
}

