/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import com.payneteasy.jetty.util.IJettyContextListener;
import com.payneteasy.jetty.util.IJettyStartupParameters;
import com.payneteasy.jetty.util.JettyContextBuilder;
import com.payneteasy.jetty.util.JettyContextOption;
import com.payneteasy.jetty.util.JettyMetricsServer;
import com.payneteasy.jetty.util.JettyServer;
import com.payneteasy.jetty.util.JettyServerCreator;
import com.payneteasy.jetty.util.error.ServerStartupException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerBuilder.class);
    private int port = 8080;
    private int threadsMax = 500;
    private int threadsMin = 16;
    private int threadsIdleTimeoutMs = 60000;
    private String contextPath = "/app";
    private int metricsPort = 9073;
    private String metricsBuckets = "0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1, 2.5, 5, 7.5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 140, 180, 240, 300, 400, 600, 700, 800";
    private boolean metricsEnabled = false;
    private final List<ServletContainer> servlets = new ArrayList<ServletContainer>();
    private final List<FilterContainer> filters = new ArrayList<FilterContainer>();
    private Runnable shutdownListener;
    private JettyContextOption contextOption = JettyContextOption.NO_SESSIONS;
    private IJettyContextListener contextListener;

    public JettyServerBuilder startupParameters(IJettyStartupParameters aStartup) {
        this.port = aStartup.getJettyPort();
        this.threadsMax = aStartup.getJettyMaxThreads();
        this.threadsMin = aStartup.getJettyMinThreads();
        this.threadsIdleTimeoutMs = aStartup.getJettyIdleTimeoutMs();
        this.contextPath = aStartup.getJettyContext();
        this.metricsPort = aStartup.getJettyMetricsPort();
        this.metricsBuckets = aStartup.metricsRequestsBuckets();
        this.metricsEnabled = aStartup.isJettyMetricsEnabled();
        return this;
    }

    public JettyServerBuilder contextOption(JettyContextOption aOption) {
        this.contextOption = aOption;
        return this;
    }

    public JettyServerBuilder contextListener(IJettyContextListener aListener) {
        this.contextListener = aListener;
        return this;
    }

    public JettyServerBuilder servlet(String aPath, HttpServlet aServlet) {
        this.servlets.add(new ServletContainer(aPath, aServlet));
        return this;
    }

    public JettyServerBuilder filter(String aPath, Filter aFilter) {
        this.filters.add(new FilterContainer(aPath, aFilter));
        return this;
    }

    public JettyServerBuilder shutdownListener(Runnable aShutdownListener) {
        this.shutdownListener = aShutdownListener;
        return this;
    }

    public JettyServer build() {
        Server jetty = JettyServerCreator.builder().port(this.port).threadsMax(this.threadsMax).threadMin(this.threadsMin).threadsIdleTimeoutMs(this.threadsIdleTimeoutMs).contextPath(this.contextPath).build().createServer();
        jetty.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStopped(LifeCycle event) {
                LOG.info("Shutting down ...");
                if (JettyServerBuilder.this.shutdownListener != null) {
                    JettyServerBuilder.this.shutdownListener.run();
                }
            }
        });
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)jetty, this.contextPath, this.contextOption.code());
        if (this.contextListener != null) {
            this.contextListener.contextDidCreate(contextHandler);
        }
        JettyContextBuilder contextBuilder = new JettyContextBuilder(contextHandler);
        this.servlets.forEach(servlet -> contextBuilder.servlet(((ServletContainer)servlet).path, ((ServletContainer)servlet).servlet));
        this.filters.forEach(filter -> contextBuilder.filter(((FilterContainer)filter).path, ((FilterContainer)filter).filter));
        if (this.metricsEnabled) {
            try {
                new JettyMetricsServer(this.metricsPort, this.metricsBuckets).registerJettyMetrics(jetty).startMetricsServer();
            }
            catch (Exception e) {
                throw new ServerStartupException("Cannot start metrics server", e);
            }
        }
        return new JettyServer(jetty);
    }

    private static class FilterContainer {
        private final String path;
        private final Filter filter;

        private FilterContainer(String path, Filter filter) {
            this.path = path;
            this.filter = filter;
        }
    }

    private static class ServletContainer {
        private final String path;
        private final HttpServlet servlet;

        private ServletContainer(String path, HttpServlet servlet) {
            this.path = path;
            this.servlet = servlet;
        }
    }
}

