/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jetty.util;

import com.payneteasy.jetty.util.IJettyStartupParameters;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServerCreator {
    private final int port;
    private final int threadsMax;
    private final int threadMin;
    private final int threadsIdleTimeoutMs;
    private final String contextPath;

    public static Server createJettyServer(IJettyStartupParameters aConfig) {
        return JettyServerCreator.builder().port(aConfig.getJettyPort()).threadsMax(aConfig.getJettyMaxThreads()).threadMin(aConfig.getJettyMinThreads()).threadsIdleTimeoutMs(aConfig.getJettyIdleTimeoutMs()).contextPath(aConfig.getJettyContext()).build().createServer();
    }

    public Server createServer() {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.threadsMax, this.threadMin, this.threadsIdleTimeoutMs);
        threadPool.setName("jetty");
        Server jetty = new Server((ThreadPool)threadPool);
        HttpConfiguration config = new HttpConfiguration();
        config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        config.setSendServerVersion(false);
        config.setSendXPoweredBy(false);
        config.setSendDateHeader(true);
        ServerConnector connector = new ServerConnector(jetty, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setPort(this.port);
        jetty.setConnectors(new Connector[]{connector});
        return jetty;
    }

    JettyServerCreator(int port, int threadsMax, int threadMin, int threadsIdleTimeoutMs, String contextPath) {
        this.port = port;
        this.threadsMax = threadsMax;
        this.threadMin = threadMin;
        this.threadsIdleTimeoutMs = threadsIdleTimeoutMs;
        this.contextPath = contextPath;
    }

    public static JettyServerCreatorBuilder builder() {
        return new JettyServerCreatorBuilder();
    }

    public static class JettyServerCreatorBuilder {
        private int port;
        private int threadsMax;
        private int threadMin;
        private int threadsIdleTimeoutMs;
        private String contextPath;

        JettyServerCreatorBuilder() {
        }

        public JettyServerCreatorBuilder port(int port) {
            this.port = port;
            return this;
        }

        public JettyServerCreatorBuilder threadsMax(int threadsMax) {
            this.threadsMax = threadsMax;
            return this;
        }

        public JettyServerCreatorBuilder threadMin(int threadMin) {
            this.threadMin = threadMin;
            return this;
        }

        public JettyServerCreatorBuilder threadsIdleTimeoutMs(int threadsIdleTimeoutMs) {
            this.threadsIdleTimeoutMs = threadsIdleTimeoutMs;
            return this;
        }

        public JettyServerCreatorBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public JettyServerCreator build() {
            return new JettyServerCreator(this.port, this.threadsMax, this.threadMin, this.threadsIdleTimeoutMs, this.contextPath);
        }

        public String toString() {
            return "JettyServerCreator.JettyServerCreatorBuilder(port=" + this.port + ", threadsMax=" + this.threadsMax + ", threadMin=" + this.threadMin + ", threadsIdleTimeoutMs=" + this.threadsIdleTimeoutMs + ", contextPath=" + this.contextPath + ")";
        }
    }
}

