/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jdbcproc.plugin.maven;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SqlDataTypes {
    private final Map<Class, Integer> dataTypes = new HashMap<Class, Integer>();
    private final Map<Integer, String> argumentNames = new HashMap<Integer, String>();
    private final Map<Integer, String> resultNames = new HashMap<Integer, String>();
    private final Map<Integer, String> examples = new HashMap<Integer, String>();

    public SqlDataTypes() {
        this.addType(String.class, 12, "varchar(50)", "varchar", "''");
        this.addType(Long.class, -5, "int(10)  unsigned", "int", "1");
        this.addType(Long.TYPE, -5, "int(10)  unsigned", "int", "1");
        this.addType(Integer.class, 4, "int(10)", "int", "1");
        this.addType(Integer.TYPE, 4, "int(10)", "int", "1");
        this.addType(Date.class, 93, "datetime", "datetime", "'2020.01.01 12:12:12'");
        this.addType(BigDecimal.class, 3, "decimal(15,3)", "decimal", "10.12");
        this.addType(Boolean.TYPE, 16, "boolean", "boolean", "false");
        this.addType(Boolean.class, 16, "boolean", "boolean", "false");
    }

    private void addType(Class aClass, int aType, String aTypeName, String aResultName, String aExample) {
        this.dataTypes.put(aClass, aType);
        this.argumentNames.put(aType, aTypeName);
        this.resultNames.put(aType, aResultName);
        this.examples.put(aType, aExample);
    }

    public short findArgumentDataType(Class<?> aType) {
        Integer type = this.dataTypes.get(aType);
        if (type == null) {
            throw new IllegalStateException("No type for " + aType);
        }
        return type.shortValue();
    }

    public String getArgumentTypeName(int aType) {
        String name = this.argumentNames.get(aType);
        if (name == null) {
            throw new IllegalStateException("No type for " + aType);
        }
        return name;
    }

    public String getResultTypeName(int aType) {
        String name = this.resultNames.get(aType);
        if (name == null) {
            throw new IllegalStateException("No type for " + aType);
        }
        return name;
    }

    public String getExampleValue(int dataType) {
        return this.examples.get(dataType);
    }
}

