/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jdbcproc.plugin.maven;

import com.googlecode.jdbcproc.daofactory.impl.procedureinfo.ResultSetColumnInfo;
import com.googlecode.jdbcproc.daofactory.impl.procedureinfo.StoredProcedureArgumentInfo;
import com.googlecode.jdbcproc.daofactory.impl.procedureinfo.StoredProcedureInfo;
import com.payneteasy.jdbcproc.plugin.maven.SqlDataTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureWriter.class);
    private static final SqlDataTypes TYPES = new SqlDataTypes();
    private final PrintWriter out;

    public ProcedureWriter(File file) throws FileNotFoundException {
        this.out = new PrintWriter(file);
    }

    public void write(StoredProcedureInfo procedure) {
        String procedureName = procedure.getProcedureName();
        String procedureSpaces = this.getProcedureSpaces(procedureName);
        this.printf("drop procedure if exists %s;", procedureName);
        this.printf("delimiter $$", new Object[0]);
        this.printf("create procedure %s(", procedureName);
        this.writeArguments(procedure.getArguments(), procedureSpaces);
        this.printf("                 %s)", procedureSpaces);
        this.printf("  begin", new Object[0]);
        this.writeSelect(procedure.getResultSetColumns());
        this.printf("  end", new Object[0]);
        this.printf("$$", new Object[0]);
        this.printf("delimiter ;", new Object[0]);
        this.writeResult(procedure.getResultSetColumns(), procedureName);
        this.out.close();
    }

    private void writeSelect(List<ResultSetColumnInfo> aColumns) {
        if (aColumns.size() == 0) {
            this.printf("    --", new Object[0]);
            return;
        }
        int maxLength = aColumns.stream().map(ResultSetColumnInfo::getColumnName).mapToInt(String::length).max().orElse(0);
        this.printf("    select", new Object[0]);
        for (int i = 0; i < aColumns.size(); ++i) {
            ResultSetColumnInfo column = aColumns.get(i);
            String comma = i < aColumns.size() - 1 ? "," : "";
            this.printf("        %s %s%s", TYPES.getExampleValue(column.getDataType()), column.getColumnName(), comma);
        }
        this.printf("    ;", new Object[0]);
    }

    private void writeResult(List<ResultSetColumnInfo> aColumns, String aName) {
        if (aColumns.size() == 0) {
            return;
        }
        this.printf("call save_routine_information('%s',", aName);
        this.printf("                              concat_ws(',',", new Object[0]);
        int maxLength = aColumns.stream().map(ResultSetColumnInfo::getColumnName).mapToInt(String::length).max().orElse(0);
        for (int i = 0; i < aColumns.size(); ++i) {
            ResultSetColumnInfo column = aColumns.get(i);
            String comma = i < aColumns.size() - 1 ? "," : "";
            this.printf("                                       '%s %s'%s", this.padRight(column.getColumnName(), maxLength), TYPES.getResultTypeName(column.getDataType()), comma);
        }
        this.printf("                                       )", new Object[0]);
        this.printf("                             );", new Object[0]);
    }

    private void writeArguments(List<StoredProcedureArgumentInfo> arguments, String procedureSpaces) {
        int maxLength = arguments.stream().map(StoredProcedureArgumentInfo::getColumnName).mapToInt(String::length).max().orElse(0);
        for (int i = 0; i < arguments.size(); ++i) {
            String comma = i < arguments.size() - 1 ? "," : "";
            StoredProcedureArgumentInfo argument = arguments.get(i);
            this.printf("                 %s i_%s %s%s", procedureSpaces, this.padRight(argument.getColumnName(), maxLength), TYPES.getArgumentTypeName(argument.getDataType()), comma);
        }
    }

    private String padRight(String columnName, int maxLength) {
        StringBuilder sb = new StringBuilder(maxLength);
        sb.append(columnName);
        while (sb.length() < maxLength) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String getProcedureSpaces(String procedureName) {
        StringBuilder sb = new StringBuilder(procedureName.length());
        while (sb.length() < procedureName.length()) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private void printf(String aTemplate, Object ... args) {
        this.out.printf(aTemplate + "\n", args);
    }
}

