/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.jdbcproc.plugin.maven;

import com.googlecode.jdbcproc.daofactory.annotation.AMetaLoginInfo;
import com.googlecode.jdbcproc.daofactory.annotation.AStoredProcedure;
import com.googlecode.jdbcproc.daofactory.impl.block.BlockFactoryUtils;
import com.googlecode.jdbcproc.daofactory.impl.procedureinfo.ResultSetColumnInfo;
import com.googlecode.jdbcproc.daofactory.impl.procedureinfo.StoredProcedureInfo;
import com.payneteasy.jdbcproc.plugin.maven.ClassUtils;
import com.payneteasy.jdbcproc.plugin.maven.CreateOneToOne;
import com.payneteasy.jdbcproc.plugin.maven.SqlDataTypes;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;

public class ProcedureInfoCreator {
    private static final short ARGUMENT_IN = 1;
    private final SqlDataTypes dataTypes = new SqlDataTypes();
    private final CreateOneToOne createOneToOne = new CreateOneToOne();
    private final String loginUsername;
    private final String loginRoleName;

    public ProcedureInfoCreator(String loginUsername, String loginRoleName) {
        this.loginUsername = loginUsername;
        this.loginRoleName = loginRoleName;
    }

    public List<StoredProcedureInfo> createProcedures(Class aClass) {
        return ClassUtils.getAllMethods(aClass).stream().filter(method -> method.isAnnotationPresent(AStoredProcedure.class)).map(this::createProcedure).collect(Collectors.toList());
    }

    private StoredProcedureInfo createProcedure(Method aMethod) {
        AStoredProcedure procedure = aMethod.getAnnotation(AStoredProcedure.class);
        StoredProcedureInfo info = new StoredProcedureInfo(procedure.name());
        this.addMetaLogin(info, aMethod);
        for (Class<?> type : aMethod.getParameterTypes()) {
            this.addArgumentFromType(info, type);
        }
        this.addReturn(info, this.fixCollection(aMethod.getReturnType(), aMethod.getGenericReturnType()));
        return info;
    }

    private void addMetaLogin(StoredProcedureInfo aInfo, Method aMethod) {
        if (!aMethod.isAnnotationPresent(AMetaLoginInfo.class)) {
            return;
        }
        aInfo.addColumn(this.loginUsername, (short)1, this.dataTypes.findArgumentDataType(String.class));
        aInfo.addColumn(this.loginRoleName, (short)1, this.dataTypes.findArgumentDataType(String.class));
    }

    private Class<?> fixCollection(Class aClass, Type returnType) {
        if (BlockFactoryUtils.isCollectionAssignableFrom((Class)aClass)) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return aClass;
    }

    private void addReturn(StoredProcedureInfo info, Class<?> type) {
        if (type == Void.TYPE) {
            return;
        }
        ClassUtils.getAllMethods(type).stream().filter(method -> method.isAnnotationPresent(Column.class)).forEach(method -> {
            Column column = method.getAnnotation(Column.class);
            info.addResultSetColumn(new ResultSetColumnInfo(column.name(), (int)this.dataTypes.findArgumentDataType(method.getReturnType())));
        });
        List<ResultSetColumnInfo> oneToOneColumns = this.createOneToOne.createOneToOneColumns(type);
        for (ResultSetColumnInfo column : oneToOneColumns) {
            info.addResultSetColumn(column);
        }
    }

    private void addArgumentFromType(StoredProcedureInfo info, Class<?> type) {
        ClassUtils.getAllMethods(type).stream().filter(method -> method.isAnnotationPresent(Column.class)).forEach(method -> {
            Column column = method.getAnnotation(Column.class);
            info.addColumn(column.name(), (short)1, this.dataTypes.findArgumentDataType(method.getReturnType()));
        });
    }
}

